package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 表单配置实体类
 *
 * @author zxw
 * @date 2020-11-21 15:51:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_form_config")
@CrmTable(name = "mdm_form_config",tableNote = "表单配置",indexes = {
        @Index(name = "mdm_form_config_index1",columnList = "function_code")
})
public class MdmFormConfigEntity extends CrmExtTenEntity<MdmFormConfigEntity> {

    @ApiModelProperty("菜单编码")
    @SaturnColumn(description = "菜单编码")
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
	@CrmColumn(name = "field", length = 64)
    private String field;

    @ApiModelProperty("标签")
    @SaturnColumn(description = "标签")
	@CrmColumn(name = "title", length = 64)
    private String title;

    @ApiModelProperty("控件")
    @SaturnColumn(description = "控件")
	@CrmColumn(name = "class_name", length = 64)
    private String className;

    @ApiModelProperty("值")
    @SaturnColumn(description = "值")
	@CrmColumn(name = "formvalue", length = 64)
    private String formvalue;

    @ApiModelProperty("刷新")
    @SaturnColumn(description = "刷新")
	@CrmColumn(name = "refresh", length = 64)
    private Boolean refresh;

    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
	@CrmColumn(name = "props", length = 64)
    private String props;

    @ApiModelProperty("事件")
    @SaturnColumn(description = "事件")
	@CrmColumn(name = "formon", length = 64)
    private String formon;

    @ApiModelProperty("操作")
    @SaturnColumn(description = "操作")
	@CrmColumn(name = "formoptions", length = 64)
    private String formoptions;

    @ApiModelProperty("校验")
    @SaturnColumn(description = "校验")
	@CrmColumn(name = "form_validate", length = 64)
    private String validate;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    @SaturnColumn(description = "显示模式：true显示，false隐藏")
	@CrmColumn(name = "visible", length = 64)
    private Boolean visible;

    @ApiModelProperty("对齐方式")
    @SaturnColumn(description = "对齐方式")
	@CrmColumn(name = "align", length = 64)
    private String align;

    @ApiModelProperty("类型")
    @SaturnColumn(description = "类型")
	@CrmColumn(name = "type", length = 64)
    private String type;

    @ApiModelProperty("宽度")
    @SaturnColumn(description = "宽度")
	@CrmColumn(name = "width", length = 64)
    private String width;

    @ApiModelProperty("位置")
    @SaturnColumn(description = "位置")
	@CrmColumn(name = "fixed", length = 64)
    private String fixed;

    @ApiModelProperty("顺序")
    @SaturnColumn(description = "顺序")
	@CrmColumn(name = "formorder", length = 64)
    private String formorder;

    @ApiModelProperty("列样式")
    @SaturnColumn(description = "列样式")
	@CrmColumn(name = "col", length = 64)
    private String col;

    @ApiModelProperty("是否必填")
	@CrmColumn(name = "required", length = 64)
    private String required;

}
