package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 功能列表与按钮关联表实体类
 *
 * @author zxw
 * @date 2020-12-05 12:56:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_function_sub_button")
@CrmTable(name = "mdm_function_sub_button",tableNote = "功能列表与按钮关联表实体类",indexes = {
        @Index(name = "function_sub_button_index1",columnList ="parent_code" )
})
public class MdmFunctionSubButtonEntity extends CrmExtTenEntity<MdmFunctionSubButtonEntity> {


    /**
     * 按钮编码
     */
	@CrmColumn(name = "button_code", length = 64)
    private String buttonCode;

    /**
     * 询问语
     */
	@CrmColumn(name = "ask", length = 200)
    private String ask;

    /**
     * 功能查询地址
     */
	@CrmColumn(name = "query_url", length = 64)
    private String queryUrl;

    /**
     * url
     */
	@CrmColumn(name = "api_url", length = 255)
    private String apiUrl;

    /**
     * 按钮操作类型
     */
	@CrmColumn(name = "button_operation_type", length = 64)
    private String buttonOperationType;

    /**
     * 上级菜单编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 功能列表编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 排序
     */
	@CrmColumn(name = "button_order", length = 64)
    private Integer buttonOrder;

    /**
     * 功能编码
     */
	@CrmColumn(name = "do_code", length = 64)
    private String doCode;

    /**
     * 显示模式：true显示，false隐藏
     */
	@CrmColumn(name = "visible", length = 64)
    private String visible;

    @ApiModelProperty("导入按钮编码")
	@CrmColumn(name = "config_code", length = 64)
    private String configCode;

}
