package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 下级菜单表实体类
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_function_sub")
@CrmTable(name = "mdm_function_sub",tableNote = "下级菜单表",indexes = {
        @Index(name = "mdm_function_sub_index1",columnList = "function_code"),
        @Index(name = "mdm_function_sub_index2",columnList = "parent_code")
})
public class MdmFunctionSubEntity extends CrmExtTenEntity<MdmFunctionSubEntity> {


    /**
     * 下级菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 下级菜单名称
     */
	@CrmColumn(name = "function_name", length = 64)
    private String functionName;

    /**
     * 上级菜单编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 菜单类型
     */
	@CrmColumn(name = "function_type", length = 64)
    private String functionType;

    @ApiModelProperty("url")
	@CrmColumn(name = "api_url", length = 200)
    private String apiUrl;

    @ApiModelProperty("vo名称")
	@CrmColumn(name = "vo_name", length = 64)
    private String voName;

    @ApiModelProperty("权限对象配置，以逗号隔开")
	@CrmColumn(name = "permission_obj", length = 64)
    private String permissionObj;


}
