package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 页面配置实体类
 *
 * @author zxw
 * @date 2020-11-21 14:25:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_table_config")
@CrmTable(name = "mdm_table_config",tableNote = "页面配置",indexes = {
        @Index(name ="mdm_table_config_index1",columnList ="function_code" )
})
public class MdmTableConfigEntity extends CrmExtTenEntity<MdmTableConfigEntity> {


    /**
     * 菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 是否有边框
     */
	@CrmColumn(name = "border", length = 64)
    private Boolean border;

    /**
     * 是否允许拖动列宽是否允许拖动列宽
     */
	@CrmColumn(name = "resizable", length = 64)
    private Boolean resizable;

    /**
     * 标签名称
     */
	@CrmColumn(name = "show_header", length = 64)
    private String showHeader;

    /**
     * 默认显示
     */
	@CrmColumn(name = "empty_text", length = 64)
    private String emptyText;

    /**
     * 宽度
     */
	@CrmColumn(name = "width", length = 64)
    private String width;

    /**
     * 对齐方式
     */
	@CrmColumn(name = "align", length = 64)
    private String align;

    /**
     * 选中行
     */
	@CrmColumn(name = "highlight_hove_row", length = 64)
    private Boolean highlightHoveRow;

    /**
     *是否展示省略号
     */
	@CrmColumn(name = "show_overflow", length = 64)
    private Boolean showOverflow;

    /**
     * 高度
     */
	@CrmColumn(name = "height", length = 64)
    private String height;

    /**
     * 是否保持原始值状态
     */
	@CrmColumn(name = "keep_source", length = 64)
    private Boolean keepSource;

    /**
     * 编辑配置
     */
	@CrmColumn(name = "edit_config", length = 64)
    private String editConfig;

	@CrmColumn(name = "tree_config", length = 64)
    private String treeConfig;

    /**
     * 搜索框配置
     */
	@CrmColumn(name = "form_config", length = 64)
    private String formConfig;

    /**
     * 后台请求地址
     */
	@CrmColumn(name = "url", length = 64)
    private String url;

}
