package com.biz.crm.terminal.model;




import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * @author Liao Hua
 * @date 2020/9/7 3:58 下午
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_contact")
@ApiModel(value = "终端扩展信息Vo")
@CrmTable(name = "mdm_terminal_contact",tableNote = "终端扩展信息",indexes = {
        @Index(name = "mdm_terminal_contact_index1",columnList = "terminal_code")
})
public class MdmTerminalContactEntity extends CrmExtTenEntity<MdmTerminalContactEntity> {

  /**
   * 终端ID
   */
	@CrmColumn(name = "terminal_code", length = 64)
  private String terminalCode;

  /**
   * 联系人姓名
   */
	@CrmColumn(name = "contact_name", length = 128)
  private String contactName;

  /**
   * 联系人电话
   */
	@CrmColumn(name = "contact_phone", length = 64)
  private String contactPhone;

  @ApiModelProperty("主联系人,1是0否")
	@CrmColumn(name = "contact_main", length = 64)
  private String contactMain;
}
