package com.biz.crm.terminal.model;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

import java.util.List;

/**
 * @author ql
 * @date 2021/3/10
 * @time 9:53
 * 客户和终端推送到ES的实体
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Document(indexName = "mdm_terminal_customer_index3", type = "mdm_terminal_customer_type3")
public class MdmTerminalCustomerElasticsearchEntity extends CrmExtVo {

    @ApiModelProperty("高德地图ID")
    private String amapId;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("市")
    private String cityCode;

    @ApiModelProperty("区")
    private String districtCode;

    @ApiModelProperty("省")
    private String provinceCode;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    /**
     * 经维度，中间逗号隔开
     */
    @GeoPointField
    @ApiModelProperty("经维度，中间英文半角隔开")
    private String placePoint;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("终端/客户主联系人姓名")
    private String contactName;

    @ApiModelProperty("终端/客户联系方式")
    private String contactPhone;

    @ApiModelProperty("终端：供货关系职位编码集合；客户：对接人职位编码集合。都是按照;分割")
    private String positionCodes;

    @ApiModelProperty("大类")
    private String clientType;
    @ApiModelProperty("网点类型名称")
    private String clientTypeName;
    @ApiModelProperty("细类")
    private String clientSubclass;
    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @Field(type=FieldType.Keyword)
    private String actApproveStatus;

    private List<String> positionCodeList;
    private List<String> customerCodeList;
    private List<String> orgCodeList;
    private List<String> supplyNameList;
}
