package com.biz.crm.terminal.model;




import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 终端与组织关联表实体类
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_r_org")
@CrmTable(name = "mdm_terminal_r_org",tableNote = "终端与组织关联表实体类",indexes = {
        @Index(name = "mdm_terminal_r_org_index1",columnList ="terminal_code" ),
        @Index(name = "mdm_terminal_r_org_index2",columnList ="org_code" )
})
public class MdmTerminalROrgEntity extends CrmTreeTenEntity<MdmTerminalROrgEntity> {

    /**
     * 终端编码
     */
	@CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

}
