package com.biz.crm.terminal.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * @author Liao Hua
 * @date 2020/9/7 3:58 下午
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_supply_detail")
@CrmTable(name = "mdm_terminal_supply_detail",indexes = {
        @Index(name ="terminal_supply_detail_index1",columnList ="code" )
})
public class MdmTerminalSupplyDetailEntity extends CrmExtTenEntity<MdmTerminalSupplyDetailEntity> {

  @ApiModelProperty("类型 1: 商品 2：层级")
	@CrmColumn(name = "data_type", length = 64)
  private String dataType ;
  @ApiModelProperty("编码")
	@CrmColumn(name = "code", length = 64)
  private String code ;
  @ApiModelProperty("描述")
	@CrmColumn(name = "name", length = 128)
  private String name ;
  @ApiModelProperty("供货关系ID")
	@CrmColumn(name = "supply_id", length = 64)
  private String supplyId;
}
