package com.biz.crm.terminal.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * @author Liao Hua
 * @date 2020/9/7 3:58 下午
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_supply")
@CrmTable(name = "mdm_terminal_supply",indexes = {
        @Index(name = "mdm_terminal_supply_index1",columnList = "terminal_code"),
        @Index(name = "mdm_terminal_supply_index2",columnList = "org_code"),
        @Index(name = "mdm_terminal_supply_index3",columnList = "customer_code"),
        @Index(name = "mdm_terminal_supply_index4",columnList = "position_code"),
        @Index(name = "mdm_terminal_supply_index5",columnList = "user_name"),
})
public class MdmTerminalSupplyEntity extends CrmExtTenEntity<MdmTerminalSupplyEntity> {

    /**
     * 供货关系分组
     */
    @CrmColumn(name = "supply_type", length = 64, note = "供货关系类型")
    private String supplyType;

    /**
     * 用户账号
     */
    @CrmColumn(name = "user_name", length = 64, note = "用户账号")
    private String userName;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;


    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;


    /**
     * 上级客户编码
     */
    @CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 职位编码
     **/
    @CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 销售公司
     */
    @CrmColumn(name = "sale_company", length = 64)
    private String saleCompany;

    /**
     * 渠道
     */
    @CrmColumn(name = "channel", length = 64)
    private String channel;

}
