package com.biz.crm.user.model;



import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;





/**
 * @author ql
 * @date 2021/2/4
 * @time 18:34
 * 终端和角色关联表实体
 **/
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_rel_role")
@CrmTable(name = "mdm_terminal_rel_role")
public class MdmTerminalRelRoleEntity extends BaseIdEntity {

    /**
     * 终端编码
     */
	@CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

  /**
   * 终端与终端用户关联id
   */
  @CrmColumn(name = "user_rel_id", length = 64)
  private String userRelId;
}
