package com.biz.crm.user.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 用户信息表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user")
@CrmTable(name = "mdm_user",tableNote = "用户信息表",indexes = {
        @Index(name = "mdm_user_index1",columnList = "user_name",unique = true)
})
public class MdmUserEntity extends CrmExtEntity<MdmUserEntity> {

    /**
     * 用户账号登录信息
     */
	@CrmColumn(name = "user_name", length = 64)
    private String userName;

    /**
     * 用户编码
     */
    @Deprecated
	@CrmColumn(name = "user_code", length = 64)
    private String userCode;

    /**
     * 密码（经过加密的）
     */
	@CrmColumn(name = "user_password", length = 64)
    private String userPassword;

    /**
     * 用户类型
     */
	@CrmColumn(name = "user_type", length = 64)
    private String userType;

    /**
     * 性别
     */
	@CrmColumn(name = "gender", length = 64)
    private String gender;

    /**
     * 电话
     */
	@CrmColumn(name = "user_phone", length = 64)
    private String userPhone;

    /**
     * 人员姓名
     */
	@CrmColumn(name = "full_name", length = 128)
    private String fullName;

    /**
     * 生效时间
     */
	@CrmColumn(name = "end_time", length = 64)
    private String endTime;

    /**
     * 失效时间
     */
	@CrmColumn(name = "start_time", length = 64)
    private String startTime;

    /**
     * 邮箱
     */
	@CrmColumn(name = "email", length = 64)
    private String email;

    /**
     * 锁定状态 003/009
     */
	@CrmColumn(name = "lock_state", length = 64)
    private String lockState;

    /**
     * 最后一次登录时间
     */
	@CrmColumn(name = "last_login_time", length = 64)
    private String lastLoginTime;

    /**
     * 用户头像
     */
	@CrmColumn(name = "user_head_url", length = 255)
    private String userHeadUrl;

    /**
     * 是否需要强制修改密码 0/1
     */
    @CrmColumn(name = "force_change_password", length = 4)
    private String forceChangePassword;

    @CrmColumn(name = "job_code", length = 32, note = "工号")
    private String jobCode;

    @CrmColumn(name = "employee_type", length = 32, note = "员工类型")
    private String employeeType;

    @CrmColumn(name = "employee_status", length = 32, note = "员工状态")
    private String employeeStatus;

    @CrmColumn(name = "identity_card_number", length = 32, note = "身份证号码")
    private String identityCardNumber;

    @CrmColumn(name = "identity_card_address", length = 255, note = "身份证地址")
    private String identityCardAddress;

    @CrmColumn(name = "nationality", length = 32, note = "民族")
    private String nationality;

    @CrmColumn(name = "current_address", length = 255, note = "现住址")
    private String currentAddress;

    @CrmColumn(name = "political_affiliation", length = 128, note = "政治面貌")
    private String politicalAffiliation;

    @CrmColumn(name = "update_password_date", length = 10, note = "每隔三个月修改密码修改时间")
    private String updatePasswordDate;

    @CrmColumn(name = "registration_id",length = 200,note = "设备码")
    private String registrationId;

}
