package com.biz.crm.user.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 用户登录日志表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user_login_log")
@CrmTable(name = "mdm_user_login_log", tableNote = "用户登录日志表", indexes = {
        @Index(name = "i_m_user_login_log_user_name", columnList = "user_name")
})
public class MdmUserLoginLogEntity extends BaseIdEntity {

    @CrmColumn(name = "user_name", nullable = false, length = 32, note = "用户登录名")
    private String userName;

    @CrmColumn(name = "full_name", length = 128, note = "用户姓名")
    private String fullName;

    @CrmColumn(name = "from_type", length = 32, note = "登录来源")
    private String fromType;

    @CrmColumn(name = "login_date_time", nullable = false, length = 19, note = "登录时间 yyyy-MM-dd HH:mm:ss")
    private String loginDateTime;

    @CrmColumn(name = "client_ip", length = 32, note = "客户端IP地址")
    private String clientIp;

    @CrmColumn(name = "client_continent_en", length = 64, note = "客户端大洲(en)")
    private String clientContinentEn;

    @CrmColumn(name = "client_continent_zh", length = 64, note = "客户端大洲(zh_cn)")
    private String clientContinentZh;

    @CrmColumn(name = "client_country_en", length = 64, note = "客户端国家(en)")
    private String clientCountryEn;

    @CrmColumn(name = "client_country_zh", length = 64, note = "客户端国家(zh_cn)")
    private String clientCountryZh;

    @CrmColumn(name = "client_subdivision_en", length = 64, note = "客户端省份(en)")
    private String clientSubdivisionEn;

    @CrmColumn(name = "client_subdivision_zh", length = 64, note = "客户端省份(zh_cn)")
    private String clientSubdivisionZh;

    @CrmColumn(name = "client_city_en", length = 64, note = "客户端城市(en)")
    private String clientCityEn;

    @CrmColumn(name = "client_city_zh", length = 64, note = "客户端城市(zh_cn)")
    private String clientCityZh;

    @CrmColumn(name = "client_latitude", length = 16, note = "客户端纬度")
    private String clientLatitude;

    @CrmColumn(name = "client_longitude", length = 16, note = "客户端经度")
    private String clientLongitude;

    @CrmColumn(name = "server_ip", length = 32, note = "服务器ip")
    private String serverIp;

    @CrmColumn(name = "server_name", length = 128, note = "服务器域名")
    private String serverName;

    @CrmColumn(name = "server_port", length = 8, note = "服务器端口号")
    private String serverPort;

}
