package com.biz.crm.user.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user_rel_customer")
@CrmTable(name = "mdm_user_rel_customer", tableNote = "客户用户与客户关联表", indexes = {
        @Index(name = "uk_m_user_name_rel_customer_code", unique = true, columnList = "user_name,customer_code")
})
public class MdmUserRelCustomerEntity extends BaseIdEntity {

    @CrmColumn(name = "current_flag", nullable = false, length = 8, note = "当前客户标记（用于登录）", defaultValue = "'0'")
    private String currentFlag;

    @CrmColumn(name = "user_name", nullable = false, length = 32, note = "用户登录名")
    private String userName;

    @CrmColumn(name = "customer_code", nullable = false, length = 32, note = "客户编码")
    private String customerCode;

}
