package com.biz.crm.user.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user_rel_role")
@CrmTable(name = "mdm_user_rel_role", tableNote = "用户与权限角色关联表", indexes = {
        @Index(name = "uk_m_user_name_rel_role_code", unique = true, columnList = "user_name,role_code")
})
public class MdmUserRelRoleEntity extends BaseIdEntity {

    @CrmColumn(name = "user_name", length = 32, nullable = false, note = "用户登录名")
    private String userName;

    @CrmColumn(name = "role_code", length = 32, nullable = false, note = "权限角色编码")
    private String roleCode;

}