package com.biz.crm.user.model;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * @author ql
 * @date 2021/2/4
 * @time 17:56
 * 终端用户与终端关联实体
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user_rel_terminal")
@CrmTable(name = "mdm_user_rel_terminal", tableNote = "终端用户与终端关联")
public class MdmUserRelTerminalEntity extends BaseIdEntity {

    @CrmColumn(name = "current_flag", length = 64, defaultValue = "'0'", note = "当前终端标记")
    private String currentFlag;

    @CrmColumn(name = "user_name", length = 64, nullable = false, note = "用户登录名")
    private String userName;

    @CrmColumn(name = "terminal_code", length = 64, nullable = false, note = "终端编码")
    private String terminalCode;
}
