package com.biz.crm.user.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 用户关联微信实体类
 *
 * @author Tao.Chen
 * @date 2021-02-19 11:47:07
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user_rel_we_chat")
@CrmTable(name = "mdm_user_rel_we_chat",tableNote = "用户关联微信实体类")
public class MdmUserRelWeChatEntity extends BaseIdEntity {

    /**
     * 微信来源模块
     */
	@CrmColumn(name = "origin_module", length = 64)
    private String originModule;

    /**
     * 用户登录名
     */
	@CrmColumn(name = "user_name", length = 64)
    private String userName;

    /**
     * 微信openId
     */
	@CrmColumn(name = "open_id", length = 64)
    private String openId;

    /**
     * 当前是否处于登录状态 1是 0否
     */
	@CrmColumn(name = "login_status", length = 64)
    private String loginStatus;

    /**
     * 微信头像
     */
	@CrmColumn(name = "head_img_url", length = 255)
    private String headImgUrl;

    /**
     * 微信昵称
     */
	@CrmColumn(name = "nick_name", length = 64)
    private String nickName;

}
