/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmcustomermsg"})
@Api(tags={"\u5ba2\u6237\u4fe1\u606f"})
@CrmGlobalLog
public class MdmCustomerMsgController {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgController.class);
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868,\u5982\u679c\u6709\u7ec4\u7ec7\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u5ba2\u6237\u4fe1\u606f")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> list(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        PageResult<MdmCustomerMsgRespVo> result = this.mdmCustomerMsgService.findList(mdmCustomerMsgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u5c42\u7ea7\u6240\u6709\u5ba2\u6237\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/customer_code_list"})
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> list) {
        return Result.ok(this.mdmCustomerMsgService.findByOrgCodeList(list));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmCustomerMsgRespVo> query(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgRespVo model = this.mdmCustomerMsgService.query(mdmCustomerMsgReqVo);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.save(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.update(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.deleteBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.enableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.disableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5bf9\u63a5\u4eba\u804c\u4f4d\u4e0b\u62c9\u6846")
    @PostMapping(value={"/docking_select"})
    public Result<List<MdmCustomerDockingRespVo>> dockingSearch(@RequestBody MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return Result.ok(this.mdmCustomerMsgService.dockingSearch(mdmCustomerDockingSearchReqVo));
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539\u8054\u7cfb\u4eba")
    @PostMapping(value={"/contact_batch"})
    public Result<Object> addOrUpdateBatch(@Valid @RequestBody List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        this.mdmCustomerMsgService.addOrUpdateBatch(mdmCustomerContactReqVos);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539\u5bf9\u63a5\u4eba")
    @PostMapping(value={"/dock_batch"})
    public Result<Object> addOrUpdateBatchDocking(@Valid @RequestBody List<MdmCustomerDockingReqVo> mdmCustomerDockingReqVos) {
        this.mdmCustomerMsgService.addOrUpdateBatchDocking(mdmCustomerDockingReqVos);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b")
    @PostMapping(value={"/findDetailsByFormInstanceId"})
    public Result<MdmCustomerMsgRespVo> findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        ValidateUtils.validate((Object)formInstanceId, (String)"\u8868\u5355\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setFormInstanceId(formInstanceId);
        MdmCustomerMsgRespVo query = this.mdmCustomerMsgService.query(mdmCustomerMsgReqVo);
        return Result.ok((Object)query);
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u4fee\u6539\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"/update_cus_org"})
    public Result<Object> updateOrgCodeByCondition(@RequestBody MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        this.mdmCustomerMsgService.updateOrgCodeByCondition(mdmUpdateCusOrgCodeReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u5ba2\u6237")
    @PostMapping(value={"/findCurrentAndSubCustomerList"})
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<MdmCustomerMsgRespVo> currentAndSubCustomerList = this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        return Result.ok(currentAndSubCustomerList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/findCustomerSelectList"})
    @CrmDictMethod
    public Result<List<MdmCustomerMsgRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(this.mdmCustomerMsgService.list(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5ba2\u6237\u7f16\u7801")
    @PostMapping(value={"/customer_code_condition"})
    public Result<List<String>> findCustomerCodeConditionList(@RequestBody CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCustomerCodeConditionList(customerCodeConditionReqVo));
    }
}

