/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.entity.EngineCategoryDictEntity;
import com.biz.crm.dict.entity.EngineDictAttrConfEntity;
import com.biz.crm.dict.entity.EngineDictEntity;
import com.biz.crm.dict.entity.EngineDictItemEntity;
import com.biz.crm.dict.mapper.EngineDictMapper;
import com.biz.crm.dict.service.IEngineCategoryDictService;
import com.biz.crm.dict.service.IEngineDictAttrConfService;
import com.biz.crm.dict.service.IEngineDictItemService;
import com.biz.crm.dict.service.IEngineDictService;
import com.biz.crm.nebular.mdm.dict.req.EngineDictReqVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"EngineDictServiceExpandImpl"})
public class EngineDictServiceImpl
extends ServiceImpl<EngineDictMapper, EngineDictEntity>
implements IEngineDictService {
    private static final Logger log = LoggerFactory.getLogger(EngineDictServiceImpl.class);
    @Resource
    private EngineDictMapper engineDictMapper;
    @Resource
    private IEngineCategoryDictService engineCategoryDictService;
    @Autowired
    private IEngineDictAttrConfService iEngineDictAttrConfService;
    @Autowired
    private IEngineDictItemService iEngineDictItemService;

    @Override
    public PageResult<EngineDictRespVo> findList(EngineDictReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<EngineDictRespVo> list = this.engineDictMapper.findList((Page<EngineDictRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineDictRespVo query(EngineDictReqVo reqVo) {
        EngineCategoryDictEntity engineCategoryDictEntity;
        EngineDictEntity one = (EngineDictEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getDictCode()), EngineDictEntity::getDictCode, (Object)reqVo.getDictCode())).one());
        EngineDictRespVo respVo = (EngineDictRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineDictRespVo.class);
        if (StringUtils.isNotEmpty((String)one.getCategoryId()) && (engineCategoryDictEntity = (EngineCategoryDictEntity)((Object)this.engineCategoryDictService.getById((Serializable)((Object)one.getCategoryId())))) != null) {
            respVo.setCateCode(engineCategoryDictEntity.getCateCode());
            respVo.setCateName(engineCategoryDictEntity.getCateName());
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineDictReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTitle(), (String)"\u5b57\u5178\u7684\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getCateCode(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        EngineCategoryDictEntity categoryDictEntity = (EngineCategoryDictEntity)((Object)((LambdaQueryChainWrapper)this.engineCategoryDictService.lambdaQuery().eq(EngineCategoryDictEntity::getCateCode, (Object)reqVo.getCateCode())).one());
        Assert.notNull((Object)((Object)categoryDictEntity), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u5b58\u5728");
        EngineDictEntity entity = (EngineDictEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineDictEntity.class));
        entity.setCategoryId(categoryDictEntity.getId());
        entity.setDictStatus(true);
        entity.setDictType("\u901a\u7528\u578b");
        entity.setItemNum(0);
        entity.setValueType("string");
        entity.setCreateTime(new Date());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineDictReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTitle(), (String)"\u5b57\u5178\u7684\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getCateCode(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        EngineDictEntity entity = (EngineDictEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
        EngineCategoryDictEntity categoryDictEntity = (EngineCategoryDictEntity)((Object)((LambdaQueryChainWrapper)this.engineCategoryDictService.lambdaQuery().eq(EngineCategoryDictEntity::getCateCode, (Object)reqVo.getCateCode())).one());
        Assert.notNull((Object)((Object)categoryDictEntity), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u5b58\u5728");
        entity.setDictTitle(reqVo.getDictTitle());
        entity.setDescription(reqVo.getDescription());
        entity.setCategoryId(categoryDictEntity.getId());
        entity.setModifyTime(new Date());
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineDictReqVo reqVo) {
        List engineDictEntities = this.engineDictMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)engineDictEntities)) {
            engineDictEntities.forEach(o -> {
                List itemEntityList = ((LambdaQueryChainWrapper)this.iEngineDictItemService.lambdaQuery().eq(EngineDictItemEntity::getDictEntityId, (Object)o.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)itemEntityList)) {
                    throw new BusinessException("\u8be5\u5b57\u5178\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\u5b57\u5178\u503c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                }
                this.removeById((Serializable)((Object)o.getId()));
                ((LambdaUpdateChainWrapper)this.iEngineDictAttrConfService.lambdaUpdate().eq(EngineDictAttrConfEntity::getDictEntityId, (Object)o.getId())).remove();
            });
        }
    }
}

