/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.dict.entity.MdmDictAttrEntity;
import com.biz.crm.dict.entity.MdmDictDataEntity;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.dict.service.MdmDictAttrService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataFieldVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataTreeVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataVo;
import com.biz.crm.nebular.mdm.dict.dicttype.req.MdmDictTypePageReqVo;
import com.biz.crm.nebular.mdm.dict.dicttype.resp.MdmDictTypePageRespVo;
import com.biz.crm.nebular.mdm.dict.enums.MdmDictAttrEnum;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MdmDictDataServiceImpl
extends ServiceImpl<MdmDictDataMapper, MdmDictDataEntity>
implements MdmDictDataService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictDataServiceImpl.class);
    @Resource
    private MdmDictAttrService mdmDictAttrService;
    @Lazy
    @Resource
    private MdmDictTypeService mdmDictTypeService;

    @Override
    public void add(MdmDictDataVo mdmDictDataVo) {
        mdmDictDataVo.setDictDataCode(CodeUtil.getCode());
        this.checkField(mdmDictDataVo);
        this.saveDictData(mdmDictDataVo);
    }

    private void checkField(MdmDictDataVo mdmDictDataVo) {
        Assert.hasText((String)mdmDictDataVo.getDictTypeCode(), (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mdmDictDataVo.getShowOrder(), (String)"\u5b57\u5178\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmDictDataVo.getMdmDictDataFieldVos(), (String)"\u5b57\u5178\u5c5e\u6027\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictTypePageRespVo one = this.mdmDictTypeService.one(new MdmDictTypePageReqVo().setDictTypeCode(mdmDictDataVo.getDictTypeCode()));
        Assert.notNull((Object)one, (String)("\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728:" + mdmDictDataVo.getDictTypeCode()));
        List mdmDictDataFieldVos = mdmDictDataVo.getMdmDictDataFieldVos();
        MdmDictDataFieldVo mdmDictDataKey = mdmDictDataFieldVos.stream().filter(x -> MdmDictAttrEnum.MDM_DICT_KEY.getCode().equals(x.getFieldCode())).findAny().orElseThrow(() -> new BusinessException("\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)mdmDictDataKey.getDictValue(), (String)"\u5b57\u5178key\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictDataFieldVo mdmDictDataVal = mdmDictDataFieldVos.stream().filter(x -> MdmDictAttrEnum.MDM_DICT_VAL.getCode().equals(x.getFieldCode())).findAny().orElseThrow(() -> new BusinessException("\u5b57\u5178val\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)mdmDictDataVal.getDictValue(), (String)"\u5b57\u5178val\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public void remove(String dictDataCode) {
        Assert.hasText((String)dictDataCode, (String)"\u5b57\u5178\u884c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmDictDataEntity::getDictDataCode, new Object[]{dictDataCode})).remove();
    }

    @Override
    public void update(MdmDictDataVo mdmDictDataVo) {
        String dictDataCode = mdmDictDataVo.getDictDataCode();
        Assert.hasText((String)dictDataCode, (String)"\u5b57\u5178\u884c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkField(mdmDictDataVo);
        List mdmDictDataFieldVos = mdmDictDataVo.getMdmDictDataFieldVos();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmDictDataEntity::getDictDataCode, new Object[]{dictDataCode})).eq(!CollectionUtils.isEmpty((Collection)mdmDictDataFieldVos), MdmDictDataEntity::getFieldCode, mdmDictDataFieldVos.stream().map(MdmDictDataFieldVo::getFieldCode).collect(Collectors.toList()))).remove();
        this.saveDictData(mdmDictDataVo);
    }

    private void saveDictData(MdmDictDataVo mdmDictDataVo) {
        List mdmDictDataFieldVos = mdmDictDataVo.getMdmDictDataFieldVos();
        List collect = mdmDictDataFieldVos.stream().map(x -> {
            MdmDictDataEntity mdmDictDataEntity = new MdmDictDataEntity();
            mdmDictDataEntity.setDictTypeCode(mdmDictDataVo.getDictTypeCode());
            mdmDictDataEntity.setDictDataCode(mdmDictDataVo.getDictDataCode());
            mdmDictDataEntity.setFieldCode(x.getFieldCode());
            mdmDictDataEntity.setDictValue(x.getDictValue());
            mdmDictDataEntity.setShowOrder(mdmDictDataVo.getShowOrder());
            mdmDictDataEntity.setParentDictDataCode(Optional.ofNullable(mdmDictDataVo.getParentDictDataCode()).orElse(""));
            return mdmDictDataEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public List<MdmDictDataVo> findData(MdmDictDataTreeVo mdmDictDataTreeVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)mdmDictDataTreeVo.getDictTypeCode())).eq(!StringUtils.isEmpty((String)mdmDictDataTreeVo.getParentDicDataCode()), MdmDictDataEntity::getDictDataCode, (Object)mdmDictDataTreeVo.getParentDicDataCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List mdmDictAttrEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictAttrService.lambdaQuery().eq(MdmDictAttrEntity::getDictTypeCode, (Object)mdmDictDataTreeVo.getDictTypeCode())).eq(MdmDictAttrEntity::getShowModel, (Object)"1")).orderByAsc(MdmDictAttrEntity::getShowOrder)).list();
        Assert.notEmpty((Collection)mdmDictAttrEntities, (String)"\u5b57\u5178\u5c5e\u6027\u914d\u7f6e\u4e0d\u5b58\u5728");
        Map<String, List<MdmDictDataEntity>> collect = list.stream().collect(Collectors.groupingBy(MdmDictDataEntity::getDictDataCode));
        LinkedList<MdmDictDataVo> result = new LinkedList<MdmDictDataVo>();
        for (List<MdmDictDataEntity> mdmDictDataEntities : collect.values()) {
            if (CollectionUtils.isEmpty(mdmDictDataEntities)) continue;
            MdmDictDataEntity mdmDictDataEntity = mdmDictDataEntities.get(0);
            MdmDictDataVo mdmDictDataVo = (MdmDictDataVo)CrmBeanUtil.copy((Object)((Object)mdmDictDataEntity), MdmDictDataVo.class);
            Map<String, String> dataMap = mdmDictDataEntities.stream().collect(Collectors.toMap(MdmDictDataEntity::getFieldCode, x -> Optional.ofNullable(x.getDictValue()).orElse("")));
            List mdmDictDataFieldVos = mdmDictAttrEntities.stream().sorted(Comparator.comparing(MdmDictAttrEntity::getShowOrder)).map(x -> {
                MdmDictDataFieldVo mdmDictDataFieldVo = new MdmDictDataFieldVo();
                String fieldCode = x.getFieldCode();
                mdmDictDataFieldVo.setFieldCode(fieldCode);
                mdmDictDataFieldVo.setFieldName(x.getFieldName());
                if (!StringUtils.isEmpty((String)fieldCode)) {
                    mdmDictDataFieldVo.setDictValue((String)dataMap.get(x.getFieldCode()));
                }
                return mdmDictDataFieldVo;
            }).collect(Collectors.toList());
            mdmDictDataVo.setMdmDictDataFieldVos(mdmDictDataFieldVos);
            result.add(mdmDictDataVo);
        }
        return result;
    }

    @Override
    public MdmDictDataVo findDataStruct(MdmDictDataReqVo mdmDictDataReqVo) {
        MdmDictDataVo mdmDictDataVo = new MdmDictDataVo();
        String dictTypeCode = mdmDictDataReqVo.getDictTypeCode();
        Assert.hasText((String)dictTypeCode, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmDictAttrEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictAttrService.lambdaQuery().eq(MdmDictAttrEntity::getDictTypeCode, (Object)dictTypeCode)).eq(MdmDictAttrEntity::getShowModel, (Object)"1")).orderByAsc(MdmDictAttrEntity::getShowOrder)).list();
        Assert.notEmpty((Collection)mdmDictAttrEntities, (String)"\u5b57\u5178\u5c5e\u6027\u914d\u7f6e\u4e0d\u5b58\u5728");
        Map<Object, Object> dataMap = Maps.newHashMap();
        String dictDataCode = mdmDictDataReqVo.getDictDataCode();
        if (!StringUtils.isEmpty((String)dictDataCode)) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmDictDataEntity::getDictDataCode, new Object[0])).list();
            Assert.notEmpty((Collection)list, (String)("\u5f53\u524d\u884c\u7f16\u7801[" + dictDataCode + "]\u6ca1\u6709\u5b57\u5178\u6570\u636e:"));
            dataMap = list.stream().collect(Collectors.toMap(MdmDictDataEntity::getFieldCode, x -> Optional.ofNullable(x.getDictValue()).orElse("")));
            MdmDictDataEntity mdmDictDataEntity = (MdmDictDataEntity)((Object)list.get(0));
            mdmDictDataVo.setDictDataCode(mdmDictDataEntity.getDictDataCode());
            mdmDictDataVo.setParentDictDataCode(mdmDictDataEntity.getParentDictDataCode());
            mdmDictDataVo.setShowOrder(mdmDictDataEntity.getShowOrder());
        }
        HashMap fieldDataMap = dataMap;
        mdmDictDataVo.setDictTypeCode(dictTypeCode);
        List collect = mdmDictAttrEntities.stream().sorted(Comparator.comparing(MdmDictAttrEntity::getShowOrder)).map(x -> {
            MdmDictDataFieldVo mdmDictDataFieldVo = new MdmDictDataFieldVo();
            String fieldCode = x.getFieldCode();
            mdmDictDataFieldVo.setFieldCode(fieldCode);
            mdmDictDataFieldVo.setFieldName(x.getFieldName());
            if (!StringUtils.isEmpty((String)fieldCode)) {
                mdmDictDataFieldVo.setDictValue((String)fieldDataMap.get(x.getFieldCode()));
            }
            return mdmDictDataFieldVo;
        }).collect(Collectors.toList());
        mdmDictDataVo.setMdmDictDataFieldVos(collect);
        return mdmDictDataVo;
    }
}

