/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.permission.MdmListConfigReqVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.permission.mapper.MdmListConfigMapper;
import com.biz.crm.permission.model.MdmListConfigEntity;
import com.biz.crm.permission.service.IMdmListConfigService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmListConfigServiceExpandImpl"})
public class MdmListConfigServiceImpl
extends ServiceImpl<MdmListConfigMapper, MdmListConfigEntity>
implements IMdmListConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmListConfigServiceImpl.class);
    @Resource
    private MdmListConfigMapper mdmListConfigMapper;

    @Override
    public PageResult<MdmListConfigRespVo> findList(MdmListConfigReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmListConfigRespVo> list = this.mdmListConfigMapper.findList((Page<MdmListConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmListConfigRespVo query(MdmListConfigReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmListConfigReqVo reqVo) {
        MdmListConfigEntity entity = (MdmListConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmListConfigEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmListConfigReqVo reqVo) {
        MdmListConfigEntity entity = (MdmListConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmListConfigReqVo reqVo) {
        List mdmListConfigEntities = this.mdmListConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmListConfigEntities)) {
            mdmListConfigEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmListConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmListConfigReqVo reqVo) {
        List mdmListConfigEntities = this.mdmListConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmListConfigEntities)) {
            mdmListConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmListConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmListConfigReqVo reqVo) {
        List mdmListConfigEntities = this.mdmListConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmListConfigEntities)) {
            mdmListConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmListConfigEntities);
    }

    @Override
    public List<MdmListConfigRespVo> listCondition(MdmListConfigReqVo mdmListConfigReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)mdmListConfigReqVo.getListConfigCode()), MdmListConfigEntity::getListConfigCode, (Object)mdmListConfigReqVo.getListConfigCode())).like(!StringUtils.isEmpty((String)mdmListConfigReqVo.getListConfigName()), MdmListConfigEntity::getListConfigName, (Object)mdmListConfigReqVo.getListConfigName())).select(new SFunction[]{MdmListConfigEntity::getListConfigCode, MdmListConfigEntity::getListConfigName}).list();
        return CrmBeanUtil.copyList((List)list, MdmListConfigRespVo.class);
    }
}

