/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelTreeReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelTreeRespVo;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmproductlevel"})
@Api(tags={"\u4ea7\u54c1\u5c42\u7ea7"})
@CrmGlobalLog
public class MdmProductLevelController {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelController.class);
    @Autowired
    private IMdmProductLevelService mdmProductLevelService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868(\u5206\u9875)")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> list(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        PageResult<MdmProductLevelRespVo> result = this.mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5\uff08id\u6216\u8005productLevelCode\uff09")
    @PostMapping(value={"/query"})
    public Result<MdmProductLevelRespVo> query(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        return Result.ok((Object)this.mdmProductLevelService.query(mdmProductLevelReqVo.getId(), mdmProductLevelReqVo.getProductLevelCode()));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.save(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.update(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664\uff08\u4f20ids\uff09")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.deleteBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528\uff08\u4f20ids\uff09")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.enableBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528\uff08\u4f20ids\uff09")
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.disableBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b")
    @PostMapping(value={"/findDetailsByFormInstanceId"})
    public Result findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        MdmProductLevelEntity result = this.mdmProductLevelService.findDetailsByFormInstanceId(formInstanceId);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u4ea7\u54c1\u5c42\u7ea7\u6811")
    @PostMapping(value={"/tree"})
    public Result<List<MdmProductLevelTreeRespVo>> tree(@RequestBody MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        return Result.ok(this.mdmProductLevelService.tree(mdmProductLevelTreeReqVo));
    }

    @ApiOperation(value="\u53ef\u66ff\u6362\u7684\u4ea7\u54c1\u5c42\u7ea7\u6811")
    @PostMapping(value={"/edit_tree"})
    public Result<List<MdmProductLevelTreeRespVo>> editTree(@RequestBody MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        return Result.ok(this.mdmProductLevelService.editTree(mdmProductLevelTreeReqVo));
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/reload_rule_code"})
    public Result reloadRuleCode() {
        this.mdmProductLevelService.reloadRuleCode();
        return Result.ok();
    }

    @ApiOperation(value="\u4ea7\u54c1\u5c42\u7ea7\u4e0b\u62c9\u6846\u9009\u62e9\u5217\u8868")
    @PostMapping(value={"/product_level_select_list"})
    @CrmDictMethod
    public Result<List<MdmProductLevelRespVo>> productLevelSelectList(@RequestBody MdmProductLevelSelectReqVo reqVo) {
        return Result.ok(this.mdmProductLevelService.productLevelSelectList(reqVo));
    }
}

