/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.customer.service.IMdmCustomerTerminalService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmCusOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalContactRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSupplyRespVo;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.IMdmTerminalContactService;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.terminal.service.IMdmTerminalSupplyService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class MdmTerminalServiceImpl
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements IMdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private IMdmTerminalContactService iMdmTerminalContactService;
    @Autowired
    private IMdmTerminalSupplyService iMdmTerminalSupplyService;
    @Autowired
    private MdmTerminalContactMapper mdmTerminalContactMapper;
    @Autowired
    private MdmTerminalSupplyMapper mdmTerminalSupplyMapper;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private IMdmCustomerTerminalService mdmCustomerTerminalService;

    @Override
    public PageResult<MdmTerminalRespVo> findList(MdmTerminalReqVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCode())) {
            EngineOrgReqVo engineOrgReqVo = new EngineOrgReqVo();
            engineOrgReqVo.setOrgCode(mdmTerminalReqVo.getCode());
            List<String> orgCodeList = this.engineOrgService.findCurrentAndSubOrgCodeList(engineOrgReqVo);
            if (!CollectionUtils.isEmpty(orgCodeList)) {
                mdmTerminalReqVo.setOrgCodeList(orgCodeList);
            }
        }
        List<MdmTerminalRespVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalRespVo>)page, mdmTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTerminalRespVo query(MdmTerminalReqVo mdmTerminalReqVo) {
        String licenseImg;
        MdmTerminalRespVo mdmTerminalRespVo = this.mdmTerminalMapper.query(mdmTerminalReqVo);
        Assert.notNull((Object)mdmTerminalRespVo, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        String shopImg = mdmTerminalRespVo.getShopImg();
        if (!StringUtils.isEmpty((CharSequence)shopImg)) {
            mdmTerminalRespVo.setShopImagePath(Arrays.asList(shopImg.split("_")));
        }
        if (!StringUtils.isEmpty((CharSequence)(licenseImg = mdmTerminalRespVo.getLicenseImg()))) {
            mdmTerminalRespVo.setLicenseImagePath(Arrays.asList(licenseImg.split("_")));
        }
        mdmTerminalRespVo.setMdmTerminalContactRespVos(this.iMdmTerminalContactService.listCondition(mdmTerminalRespVo.getTerminalCode()));
        mdmTerminalRespVo.setMdmTerminalSupplyRespVos(this.iMdmTerminalSupplyService.listCondition(mdmTerminalRespVo.getTerminalCode()));
        return mdmTerminalRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTerminalRespVo mdmTerminalRespVo) {
        List shopImagePath;
        if (ObjectUtils.isEmpty((Object)mdmTerminalRespVo)) {
            return;
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalRespVo, MdmTerminalEntity.class));
        if (null == entity) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entity.getTerminalCode())) {
            String code = CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode());
            mdmTerminalRespVo.setTerminalCode(code);
            entity.setTerminalCode(code);
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalRespVo.getTerminalCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        }
        List licenseImagePath = mdmTerminalRespVo.getLicenseImagePath();
        if (!CollectionUtils.isEmpty((Collection)licenseImagePath)) {
            String collect = String.join((CharSequence)"_", licenseImagePath);
            entity.setLicenseImagePath(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(shopImagePath = mdmTerminalRespVo.getShopImagePath()))) {
            String join = String.join((CharSequence)"_", shopImagePath);
            entity.setShopImagePath(join);
        }
        this.save((Object)entity);
        this.updateContact(mdmTerminalRespVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalRespVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalReqVo mdmTerminalReqVo) {
        List shopImagePath;
        String id = mdmTerminalReqVo.getId();
        String terminalCode = mdmTerminalReqVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)mdmTerminalReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u7ec8\u7aef\u4e0d\u5b58\u5728");
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        MdmTerminalEntity copy = (MdmTerminalEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalReqVo, MdmTerminalEntity.class));
        List licenseImagePath = mdmTerminalReqVo.getLicenseImagePath();
        if (!CollectionUtils.isEmpty((Collection)licenseImagePath)) {
            String collect = String.join((CharSequence)"_", licenseImagePath);
            copy.setLicenseImagePath(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(shopImagePath = mdmTerminalReqVo.getShopImagePath()))) {
            String join = String.join((CharSequence)"_", shopImagePath);
            copy.setShopImagePath(join);
        }
        this.updateById((Object)copy);
        this.updateContact(mdmTerminalReqVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalReqVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public MdmTerminalRespVo findDetailsByFormInstanceId(String formInstanceId) {
        if (StringUtils.isBlank((CharSequence)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"a.form_instance_id", (Object)formInstanceId);
        MdmTerminalEntity mdmTerminalEntity = (MdmTerminalEntity)((Object)this.mdmTerminalMapper.selectOne((Wrapper)wrapper));
        MdmTerminalRespVo mdmTerminalRespVo = (MdmTerminalRespVo)CrmBeanUtil.copy((Object)((Object)mdmTerminalEntity), MdmTerminalRespVo.class);
        if (null == mdmTerminalRespVo) {
            return null;
        }
        QueryWrapper mdmTerminalContactEntityQueryWrapper = new QueryWrapper();
        mdmTerminalContactEntityQueryWrapper.eq((Object)"terminal_id", (Object)mdmTerminalRespVo.getId());
        List mdmTerminalContactEntities = this.mdmTerminalContactMapper.selectList((Wrapper)mdmTerminalContactEntityQueryWrapper);
        QueryWrapper mdmTerminalSupplyEntityQueryWrapper = new QueryWrapper();
        mdmTerminalSupplyEntityQueryWrapper.eq((Object)"terminal_id", (Object)mdmTerminalRespVo.getId());
        List mdmTerminalSupplyEntities = this.mdmTerminalSupplyMapper.selectList((Wrapper)mdmTerminalSupplyEntityQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactEntities)) {
            mdmTerminalRespVo.setMdmTerminalContactRespVos(CrmBeanUtil.copyList((List)mdmTerminalContactEntities, MdmTerminalContactRespVo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalSupplyEntities)) {
            mdmTerminalRespVo.setMdmTerminalSupplyRespVos(CrmBeanUtil.copyList((List)mdmTerminalSupplyEntities, MdmTerminalSupplyRespVo.class));
        }
        return mdmTerminalRespVo;
    }

    @Override
    public void updateCusOrgCode(MdmCusOrgTerminalReqVo mdmCusOrgTerminalReqVo) {
        if (CollectionUtils.isEmpty((Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList()) || StringUtils.isEmpty((CharSequence)mdmCusOrgTerminalReqVo.getCusOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)mdmCusOrgTerminalReqVo.getCusOrgCode())).update();
    }

    private void updateContact(MdmTerminalRespVo mdmTerminalRespVo) {
        List mdmTerminalContactRespVos = mdmTerminalRespVo.getMdmTerminalContactRespVos();
        ((LambdaUpdateChainWrapper)this.iMdmTerminalContactService.lambdaUpdate().eq(MdmTerminalContactEntity::getTerminalCode, (Object)mdmTerminalRespVo.getTerminalCode())).remove();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactRespVos)) {
            mdmTerminalContactRespVos = mdmTerminalContactRespVos.stream().peek(x -> x.setTerminalCode(mdmTerminalRespVo.getTerminalCode())).collect(Collectors.toList());
            this.iMdmTerminalContactService.saveBatch(CrmBeanUtil.copyList(mdmTerminalContactRespVos, MdmTerminalContactEntity.class));
        }
        ((LambdaUpdateChainWrapper)this.iMdmTerminalSupplyService.lambdaUpdate().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)mdmTerminalRespVo.getTerminalCode())).remove();
        List mdmTerminalSupplyRespVos = mdmTerminalRespVo.getMdmTerminalSupplyRespVos();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalSupplyRespVos)) {
            mdmTerminalSupplyRespVos = mdmTerminalSupplyRespVos.stream().peek(x -> x.setTerminalCode(mdmTerminalRespVo.getTerminalCode())).collect(Collectors.toList());
            this.iMdmTerminalSupplyService.saveBatch(CrmBeanUtil.copyList(mdmTerminalSupplyRespVos, MdmTerminalSupplyEntity.class));
        }
    }

    private void updateContact(MdmTerminalReqVo terminalReqVo) {
        List mdmTerminalContactRespVos = terminalReqVo.getMdmTerminalContactRespVos();
        ((LambdaUpdateChainWrapper)this.iMdmTerminalContactService.lambdaUpdate().eq(MdmTerminalContactEntity::getTerminalCode, (Object)terminalReqVo.getTerminalCode())).remove();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactRespVos)) {
            mdmTerminalContactRespVos = mdmTerminalContactRespVos.stream().peek(x -> x.setTerminalCode(terminalReqVo.getTerminalCode())).collect(Collectors.toList());
            this.iMdmTerminalContactService.saveBatch(CrmBeanUtil.copyList(mdmTerminalContactRespVos, MdmTerminalContactEntity.class));
        }
        ((LambdaUpdateChainWrapper)this.iMdmTerminalSupplyService.lambdaUpdate().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalReqVo.getTerminalCode())).remove();
        List mdmTerminalSupplyRespVos = terminalReqVo.getMdmTerminalSupplyRespVos();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalSupplyRespVos)) {
            mdmTerminalSupplyRespVos = mdmTerminalSupplyRespVos.stream().peek(x -> x.setTerminalCode(terminalReqVo.getTerminalCode())).collect(Collectors.toList());
            this.iMdmTerminalSupplyService.saveBatch(CrmBeanUtil.copyList(mdmTerminalSupplyRespVos, MdmTerminalSupplyEntity.class));
        }
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getOrgCode, list)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode));
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return this.mdmCustomerMsgService.dockingSearch(mdmCustomerDockingSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> findCurrentAndSubTerminalList(MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo) {
        List<EngineOrgRespVo> engineOrgRespVos;
        List orgCodeList = mdmTerminalOrgSearchReqVo.getOrgCodeList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList) && !CollectionUtils.isEmpty(engineOrgRespVos = this.engineOrgService.findCurrentAndSubOrgCodeList((EngineOrgSearchReqVo)CrmBeanUtil.copy((Object)mdmTerminalOrgSearchReqVo, EngineOrgSearchReqVo.class)))) {
            orgCodeList = engineOrgRespVos.stream().map(EngineOrgRespVo::getOrgCode).collect(Collectors.toList());
            mdmTerminalOrgSearchReqVo.setOrgCodeList(orgCodeList);
        }
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalOrgSearchReqVo.getCustomerCode())) {
            MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo = new MdmCustomerTerminalReqVo();
            mdmCustomerTerminalReqVo.setCustomerCode(mdmTerminalOrgSearchReqVo.getCustomerCode());
            mdmTerminalOrgSearchReqVo.setTerminalCodeList(this.mdmCustomerTerminalService.terminalCodeList(mdmCustomerTerminalReqVo));
        }
        return this.mdmTerminalMapper.findCurrentAndSubTerminalList(mdmTerminalOrgSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> listCondition(MdmTerminalReqVo mdmTerminalReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getId()), BaseIdEntity::getId, (Object)mdmTerminalReqVo.getId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)mdmTerminalReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmTerminalReqVo.getEnableStatus())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode()), MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalReqVo.getTerminalCode())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)mdmTerminalReqVo.getTerminalName())).in(!CollectionUtils.isEmpty((Collection)mdmTerminalReqVo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, (Collection)mdmTerminalReqVo.getTerminalCodeList())).in(!CollectionUtils.isEmpty((Collection)mdmTerminalReqVo.getOrgCodeList()), MdmTerminalEntity::getOrgCode, (Collection)mdmTerminalReqVo.getOrgCodeList())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmTerminalRespVo.class);
    }

    private void sendChangeMsg(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return;
        }
        this.advise.adviseTarget(this.terminalChangeAdviseTargetStrategy, terminalCodeList);
    }
}

