/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.constant.YesOrNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionReqVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionUnionQueryRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserCustomerVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserPositionVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserUnderlingReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserUnderlingRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserUpdatePasswordReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserViewVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUnbindUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReplaceReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalReqVo;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.org.model.EngineOrgEntity;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.position.model.EnginePositionEntity;
import com.biz.crm.position.service.EnginePositionService;
import com.biz.crm.positionlevel.service.IMdmPositionLevelService;
import com.biz.crm.rolecustomer.model.EngineRoleCustomerEntity;
import com.biz.crm.rolecustomer.service.impl.EngineRoleCustomerService;
import com.biz.crm.roleposition.model.EngineRolePositionEntity;
import com.biz.crm.roleposition.service.EngineRolePositionService;
import com.biz.crm.roleuser.service.IEngineRoleUserService;
import com.biz.crm.user.manager.MdmUserManager;
import com.biz.crm.user.mapper.EngineUserMapper;
import com.biz.crm.user.model.EngineUserEntity;
import com.biz.crm.user.service.IEngineUserService;
import com.biz.crm.userposition.model.EngineUserPositionEntity;
import com.biz.crm.userposition.service.impl.EngineUserPositionService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.bizunited.platform.common.vo.UuidVo;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"EngineUserServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class EngineUserServiceImpl
extends ServiceImpl<EngineUserMapper, EngineUserEntity>
implements IEngineUserService {
    private static final Logger log = LoggerFactory.getLogger(EngineUserServiceImpl.class);
    @Resource
    private EngineUserMapper engineUserMapper;
    @Resource
    private MdmUserManager mdmUserManager;
    @Resource
    private EngineUserPositionService engineUserPositionService;
    @Resource
    private IMdmPositionLevelService mdmPositionLevelService;
    @Resource
    private EnginePositionService enginePositionService;
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private EngineRolePositionService engineRolePositionService;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private EngineRoleCustomerService engineRoleCustomerService;
    @Resource
    private IEngineRoleUserService engineRoleUserService;

    @Override
    public PageResult<EngineUserRespVo> findList(EngineUserPageReqVo engineUserPageReqVo) {
        List<EngineUserRespVo> list;
        List<EngineOrgRespVo> orgChildrenList;
        Page page = PageUtil.buildPage((Integer)engineUserPageReqVo.getPageNum(), (Integer)engineUserPageReqVo.getPageSize());
        List<String> orgIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)engineUserPageReqVo.getCode()) && (orgChildrenList = this.engineOrgService.findOrgChildrenList(null, engineUserPageReqVo.getCode())) != null) {
            orgIds = orgChildrenList.stream().map(UuidVo::getId).collect(Collectors.toList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list = this.engineUserMapper.findList((Page<EngineUserRespVo>)page, engineUserPageReqVo, orgIds))) {
            List<EngineUserRespVo> userRoleList = this.engineUserMapper.findUserRoleList(engineUserPageReqVo, orgIds);
            HashMap userRoleMap = new HashMap(16);
            userRoleList.forEach(item -> {
                if (UserTypeEnum.CUSTOMER.getCode().equals(item.getUserType())) {
                    item.setRoleCode(item.getCustomerRoleCode());
                    item.setRoleName(item.getCustomerRoleName());
                }
            });
            Map<String, List<EngineUserRespVo>> userRoleListMap = userRoleList.stream().collect(Collectors.groupingBy(EngineUserRespVo::getUserAccount));
            if (!userRoleListMap.isEmpty()) {
                userRoleListMap.forEach((k, v) -> {
                    StringBuilder codes = new StringBuilder();
                    StringBuilder names = new StringBuilder();
                    for (int i = 0; i < v.size(); ++i) {
                        if (!StringUtils.isNotEmpty((String)((EngineUserRespVo)v.get(i)).getRoleCode())) continue;
                        if (codes.length() > 0) {
                            codes.append(",");
                            names.append(",");
                        }
                        codes.append(((EngineUserRespVo)v.get(i)).getRoleCode());
                        names.append(((EngineUserRespVo)v.get(i)).getRoleName());
                    }
                    EngineUserRespVo role = new EngineUserRespVo();
                    role.setUserAccount(k);
                    role.setRoleCode(codes.toString());
                    role.setRoleName(names.toString());
                    userRoleMap.put(k, role);
                });
            }
            list.forEach(item -> {
                if (userRoleMap.containsKey(item.getUserAccount())) {
                    EngineUserRespVo role = (EngineUserRespVo)userRoleMap.get(item.getUserAccount());
                    item.setRoleCode(role.getRoleCode());
                    item.setRoleName(role.getRoleName());
                    if (UserTypeEnum.CUSTOMER.getCode().equals(item.getUserType())) {
                        item.setCustomerRoleCode(role.getRoleCode());
                        item.setCustomerRoleName(role.getRoleName());
                    }
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> customerPage(MdmUserRelationCustomerPageReqVo mdmUserRelationCustomerPageReqVo) {
        String queryType;
        switch (queryType = mdmUserRelationCustomerPageReqVo.getQueryType()) {
            case "1": {
                return this.mdmUserManager.findUnRelationAnyUser(mdmUserRelationCustomerPageReqVo);
            }
            case "2": {
                return this.mdmUserManager.findUnRelationCurrentUser(mdmUserRelationCustomerPageReqVo);
            }
            case "3": {
                return this.mdmUserManager.findRelationCurrentUser(mdmUserRelationCustomerPageReqVo);
            }
        }
        return new PageResult();
    }

    @Override
    public void relationCustomer(MdmUserRelationCustomerReqVo mdmUserRelationCustomerReqVo) {
        Assert.hasText((String)mdmUserRelationCustomerReqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmUserRelationCustomerReqVo.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmUserRelationCustomerReqVo.getCustomerCodeList().forEach(item -> Assert.hasText((String)item, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4f20\u7a7a\u503c"));
        this.mdmUserManager.relationCustomer(mdmUserRelationCustomerReqVo);
    }

    @Override
    public void replaceCustomer(MdmUserRelationCustomerReplaceReqVo mdmUserRelationCustomerReplaceReqVo) {
        Assert.hasText((String)mdmUserRelationCustomerReplaceReqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmUserRelationCustomerReplaceReqVo.getIds(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        mdmUserRelationCustomerReplaceReqVo.getIds().forEach(item -> Assert.hasText((String)item, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c"));
        this.mdmUserManager.replaceCustomer(mdmUserRelationCustomerReplaceReqVo);
    }

    @Override
    public List<String> findAllPositionCodeByUser(String userAccount) {
        return this.mdmUserManager.findAllPositionCodeByUser(userAccount);
    }

    @Override
    public void unbindRelationCustomer(MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.mdmUserManager.unbindRelationCustomer(mdmUnbindUserRelationCustomerReqVo);
    }

    @Override
    public PageResult<MdmPositionSelectPageRespVo> positionSelect(MdmPositionSelectPageReqVo mdmPositionSelectPageReqVo) {
        return this.mdmUserManager.positionSelect(mdmPositionSelectPageReqVo);
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> terminalPage(MdmUserRelationTerminalPageReqVo mdmUserRelationTerminalPageReqVo) {
        switch (mdmUserRelationTerminalPageReqVo.getQueryType()) {
            case "1": {
                return this.mdmUserManager.findUnRelationAnyUser(mdmUserRelationTerminalPageReqVo);
            }
            case "2": {
                return this.mdmUserManager.findUnRelationCurrentUser(mdmUserRelationTerminalPageReqVo);
            }
            case "3": {
                return this.mdmUserManager.findRelationCurrentUser(mdmUserRelationTerminalPageReqVo);
            }
        }
        return new PageResult();
    }

    @Override
    public void unbindRelationTerminal(MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.mdmUserManager.unbindRelationTerminal(mdmUnbindUserRelationCustomerReqVo);
    }

    @Override
    public void relationTerminal(MdmUserRelationTerminalReqVo mdmUserRelationTerminalReqVo) {
        Assert.hasText((String)mdmUserRelationTerminalReqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmUserRelationTerminalReqVo.getTerminalCodeList(), (String)"\u5173\u8054\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
        mdmUserRelationTerminalReqVo.getTerminalCodeList().forEach(item -> Assert.hasText((String)item, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        this.mdmUserManager.relationTerminal(mdmUserRelationTerminalReqVo);
    }

    @Override
    public void replaceTerminal(MdmUserRelationTerminalReplaceReqVo mdmUserRelationTerminalReplaceReqVo) {
        List ids = mdmUserRelationTerminalReplaceReqVo.getIds();
        for (String id : ids) {
            Assert.hasText((String)id, (String)"\u7f3a\u5931id");
        }
        this.mdmUserManager.replaceTerminal(mdmUserRelationTerminalReplaceReqVo);
    }

    @Override
    public EngineUserRespVo customerUserLogin(EngineUserReqVo engineUserReqVo) {
        String userAccount = engineUserReqVo.getUserAccount();
        String userPassword = engineUserReqVo.getUserPassword();
        Assert.hasText((String)userAccount, (String)"\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        engineUserReqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)userPassword));
        EngineUserRespVo engineUserRespVo = this.engineUserMapper.findCustomerUser(engineUserReqVo);
        Assert.notNull((Object)engineUserRespVo, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        engineUserRespVo.setToken(UserUtils.getToken((String)userAccount));
        this.postLogin(engineUserRespVo);
        return engineUserRespVo;
    }

    private void postLogin(EngineUserRespVo engineUserRespVo) {
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(engineUserRespVo.getUserAccount());
        userRedis.setRealname(engineUserRespVo.getUserName());
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmUserManager.findPrimaryCustomer(engineUserRespVo.getUserAccount());
        if (mdmCustomerMsgRespVo != null) {
            userRedis.setCustcode(mdmCustomerMsgRespVo.getCustomerCode());
            userRedis.setCustname(mdmCustomerMsgRespVo.getCustomerName());
            userRedis.setOrgcode(mdmCustomerMsgRespVo.getOrgCode());
            userRedis.setOrgname(mdmCustomerMsgRespVo.getOrgName());
            engineUserRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
            engineUserRespVo.setOrgCode(mdmCustomerMsgRespVo.getOrgCode());
            engineUserRespVo.setOrgName(mdmCustomerMsgRespVo.getOrgName());
            engineUserRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        }
        UserUtils.setUser((String)engineUserRespVo.getToken(), (UserRedis)userRedis);
    }

    @Override
    public void updatePassword(EngineUserUpdatePasswordReqVo engineUserUpdatePasswordReqVo) {
        String newPassword = engineUserUpdatePasswordReqVo.getNewPassword();
        String oldPassword = engineUserUpdatePasswordReqVo.getOldPassword();
        String userAccount = engineUserUpdatePasswordReqVo.getUserAccount();
        Assert.notNull((Object)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)oldPassword, (String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)newPassword, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!oldPassword.equals(newPassword) ? 1 : 0) != 0, (String)"\u65b0\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        engineUserUpdatePasswordReqVo.setOldPassword(Md5EncryptionAndDecryption.encryPwd((String)oldPassword));
        engineUserUpdatePasswordReqVo.setNewPassword(Md5EncryptionAndDecryption.encryPwd((String)newPassword));
        this.engineUserMapper.updatePassword(engineUserUpdatePasswordReqVo);
    }

    @Override
    public void resetPassword(String userAccount) {
        Assert.hasText((String)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.engineUserMapper.resetPassword(userAccount);
    }

    @Override
    public EngineUserViewVo query(EngineUserReqVo engineUserReqVo) {
        EngineUserEntity one = (EngineUserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)engineUserReqVo.getId()), BaseIdEntity::getId, (Object)engineUserReqVo.getId())).eq(!StringUtils.isEmpty((String)engineUserReqVo.getUserAccount()), EngineUserEntity::getUserAccount, (Object)engineUserReqVo.getUserAccount())).last(DatabaseTypeUtil.SEGMENT)).one());
        EngineUserViewVo engineUserViewVo = (EngineUserViewVo)CrmBeanUtil.copy((Object)((Object)one), EngineUserViewVo.class);
        engineUserViewVo.setUserPassword("");
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)engineUserViewVo.getUserType());
        if (userTypeEnum != null) {
            engineUserViewVo.setUserTypeName(userTypeEnum.getDesc());
            switch (userTypeEnum) {
                case USER: {
                    List<EngineUserPositionVo> userPositionList = this.engineUserMapper.findUserPositionList(engineUserViewVo.getUserAccount());
                    userPositionList.forEach(item -> {
                        EnginePositionReqVo enginePositionReqVo = new EnginePositionReqVo();
                        enginePositionReqVo.setPositionCode(item.getPositionCode());
                        EnginePositionUnionQueryRespVo positionUnionInfo = this.enginePositionService.getPositionUnionInfo(enginePositionReqVo);
                        item.setRoleList(positionUnionInfo.getRoleList());
                        if (CollectionUtil.listNotEmptyNotSizeZero((List)item.getRoleList())) {
                            item.setRoleCodeList(item.getRoleList().stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.toList()));
                        }
                        item.setParentPositionCode(positionUnionInfo.getParentPositionCode());
                        item.setParentPositionName(positionUnionInfo.getParentPositionName());
                        item.setOperationType(PositionOperationEnum.HISTORY.getCode());
                        item.setOperationTypeName(PositionOperationEnum.HISTORY.getDesc());
                    });
                    engineUserViewVo.setEngineUserPositionVos(userPositionList);
                    break;
                }
                case CUSTOMER: {
                    engineUserViewVo.setEngineUserCustomerVos(this.engineUserMapper.findCustomerList(engineUserReqVo.getUserAccount()));
                    break;
                }
            }
        }
        return engineUserViewVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineUserViewVo engineUserViewVo) {
        this.verifyData(engineUserViewVo);
        EngineUserEntity userEntity = (EngineUserEntity)((Object)CrmBeanUtil.copy((Object)engineUserViewVo, EngineUserEntity.class));
        userEntity.setUseStatus(1);
        userEntity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        this.save((Object)userEntity);
        this.saveOrUpdateUserRelation(engineUserViewVo, userEntity);
    }

    @Override
    public void update(EngineUserViewVo engineUserViewVo) {
        String id = engineUserViewVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.verifyData(engineUserViewVo);
        EngineUserEntity userEntity = (EngineUserEntity)((Object)this.getById((Serializable)((Object)id)));
        CrmBeanUtil.copyProperties((Object)engineUserViewVo, (Object)((Object)userEntity));
        this.updateById((Object)userEntity);
        this.saveOrUpdateUserRelation(engineUserViewVo, userEntity);
    }

    @Override
    public void deleteBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            EngineUserEntity one = (EngineUserEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u65e0\u6548\u7684\u7528\u6237");
            this.engineRoleUserService.removeUserAccount(one.getUserAccount());
            this.engineUserPositionService.lambdaUpdate().eq(EngineUserPositionEntity::getUserId, (Object)one.getId());
            this.removeById((Serializable)((Object)one.getId()));
        });
    }

    @Override
    public void enableBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            EngineUserEntity user = (EngineUserEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)user), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(user.getEnableStatus()), (String)("\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.DISABLE.getDes() + "\u201d\u7684\u7528\u6237"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    public void disableBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            EngineUserEntity user = (EngineUserEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)user), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)("\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.ENABLE.getDes() + "\u201d\u7684\u7528\u6237"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    public EngineUserRespVo findUserDetail(EngineUserReqVo userReqVo) {
        EngineUserRespVo engineUserRespVo = this.queryCondition(userReqVo);
        String userType = engineUserRespVo.getUserType();
        Assert.isTrue(("u".equals(userType) || "c".equals(userType) ? 1 : 0) != 0, (String)"\u7c7b\u578b\u5fc5\u987b\u662f\u4f01\u4e1a\u7528\u6237\u6216\u5ba2\u6237\u7528\u6237");
        if ("u".equals(userType)) {
            String userAccount = engineUserRespVo.getUserAccount();
            EnginePositionRespVo position = this.enginePositionService.findPrimaryPositionByUserAccount(userAccount);
            if (position != null) {
                engineUserRespVo.setPositionCode(position.getPositionCode());
                engineUserRespVo.setPositionName(position.getPositionName());
            }
        } else {
            MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmUserManager.findPrimaryCustomer(engineUserRespVo.getUserAccount());
            if (mdmCustomerMsgRespVo != null) {
                engineUserRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
                engineUserRespVo.setOrgCode(mdmCustomerMsgRespVo.getOrgCode());
                engineUserRespVo.setOrgName(mdmCustomerMsgRespVo.getOrgName());
                engineUserRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
            }
        }
        return engineUserRespVo;
    }

    @Override
    public EngineUserRespVo queryCondition(EngineUserReqVo userReqVo) {
        EngineUserEntity one = (EngineUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineUserEntity::getUserAccount, (Object)userReqVo.getUserAccount())).one());
        Assert.notNull((Object)((Object)one), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        return (EngineUserRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineUserRespVo.class);
    }

    @Override
    public PageResult<EngineUserUnderlingRespVo> findUnderlingList(EngineUserUnderlingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<EngineUserUnderlingRespVo> list = this.engineUserMapper.findUnderlingList((Page<EngineUserUnderlingRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void replaceParentPosition(EngineUserUnderlingReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u9009\u62e9\u4e0b\u7ea7\u804c\u4f4d");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u8bf7\u9009\u62e9\u4e0a\u7ea7\u804c\u4f4d\u7f16\u7801");
        EnginePositionEntity parentPosition = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one());
        Assert.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
        List<EnginePositionRespVo> parentList = this.enginePositionService.getAllParentPositionList(parentPosition.getId(), null);
        List parentIdList = parentList.stream().map(UuidVo::getId).collect(Collectors.toList());
        reqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            EnginePositionEntity position = (EnginePositionEntity)((Object)((Object)this.enginePositionService.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u4e0b\u7ea7\u804c\u4f4did");
            Assert.isTrue((!parentIdList.contains(id) ? 1 : 0) != 0, (String)("\u6240\u9009\u804c\u4f4d" + parentPosition.getPositionName() + "\u662f" + position.getPositionName() + "\u7684\u4e0b\u7ea7\u804c\u4f4d\uff0c\u4e0d\u80fd\u9009\u62e9\u4f5c\u4e3a\u4e0a\u7ea7"));
            position.setParentId(parentPosition.getParentId());
            this.enginePositionService.updateById((Object)position);
        });
    }

    private void verifyData(EngineUserViewVo engineUserViewVo) {
        String userAccount = engineUserViewVo.getUserAccount();
        Assert.hasText((String)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)engineUserViewVo.getUserName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)engineUserViewVo.getGender(), (String)"\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)engineUserViewVo.getUserPhone(), (String)"\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)engineUserViewVo.getStartTime(), (String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)engineUserViewVo.getEndTime(), (String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        EngineUserEntity one = (EngineUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineUserEntity::getUserAccount, (Object)userAccount)).one());
        if (StringUtils.isEmpty((String)engineUserViewVo.getId())) {
            Assert.isNull((Object)((Object)one), (String)("\u5e10\u53f7[" + userAccount + "]\u5df2\u5b58\u5728"));
            Assert.hasText((String)engineUserViewVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)engineUserViewVo.getUserPassword())) {
            engineUserViewVo.setUserPassword(one.getUserPassword());
        } else {
            engineUserViewVo.setUserPassword(this.passwordEncrypt(engineUserViewVo.getUserPassword()));
        }
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)engineUserViewVo.getUserType());
        Assert.notNull((Object)userTypeEnum, (String)"\u7528\u6237\u7c7b\u578b\u65e0\u6548");
        switch (userTypeEnum) {
            case USER: {
                List engineUserPositionVos = engineUserViewVo.getEngineUserPositionVos();
                Assert.notEmpty((Collection)engineUserPositionVos, (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                int count = 0;
                for (EngineUserPositionVo item : engineUserPositionVos) {
                    Assert.hasText((String)item.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.hasText((String)item.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.notNull((Object)item.getIsPrimary(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    PositionOperationEnum positionOperationEnum = PositionOperationEnum.getEnumByCode((String)item.getOperationType());
                    Assert.notNull((Object)positionOperationEnum, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
                    if (Integer.valueOf(YesOrNoEnum.IO.YES.getCode()).equals(item.getIsPrimary())) {
                        Assert.notEmpty((Collection)item.getRoleCodeList(), (String)"\u4e3b\u804c\u4f4d\u7684\u6743\u9650\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
                        if (++count > 1) {
                            throw new BusinessException("\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d");
                        }
                    }
                    switch (positionOperationEnum) {
                        case NEW: {
                            Assert.hasText((String)item.getPositionLevelCode(), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                            break;
                        }
                        case HISTORY: {
                            Assert.hasText((String)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                            break;
                        }
                    }
                }
                if (count != 0) break;
                throw new BusinessException("\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u4e3b\u804c\u4f4d");
            }
            case CUSTOMER: {
                List engineUserCustomerVos = engineUserViewVo.getEngineUserCustomerVos();
                Assert.notEmpty((Collection)engineUserCustomerVos, (String)"\u5ba2\u6237\u7528\u6237\u5fc5\u987b\u5173\u8054\u5ba2\u6237");
                HashMap<String, EngineUserCustomerVo> customerUniqueMap = new HashMap<String, EngineUserCustomerVo>(16);
                for (EngineUserCustomerVo item : engineUserCustomerVos) {
                    Assert.hasText((String)item.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                    if (customerUniqueMap.containsKey(item.getCustomerCode())) {
                        throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u5ba2\u6237\u76f8\u540c\u5ba2\u6237");
                    }
                    customerUniqueMap.put(item.getCustomerCode(), item);
                }
                break;
            }
        }
    }

    private void saveOrUpdateUserRelation(EngineUserViewVo engineUserViewVo, EngineUserEntity userEntity) {
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)userEntity.getUserType());
        switch (userTypeEnum) {
            case USER: {
                this.updateUserPositionRelation(engineUserViewVo, userEntity);
                break;
            }
            case CUSTOMER: {
                this.updateUserCustomerRelation(engineUserViewVo);
                break;
            }
        }
    }

    private void updateUserCustomerRelation(EngineUserViewVo engineUserViewVo) {
        boolean setPrimary = false;
        for (EngineUserCustomerVo item : engineUserViewVo.getEngineUserCustomerVos()) {
            MdmCustomerMsgEntity customer = (MdmCustomerMsgEntity)((Object)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getCustomerCode, (Object)item.getCustomerCode())).one());
            Assert.notNull((Object)((Object)customer), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            ((LambdaUpdateChainWrapper)this.engineRoleCustomerService.lambdaUpdate().eq(EngineRoleCustomerEntity::getCustomerCode, (Object)customer.getCustomerCode())).remove();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().eq(MdmCustomerMsgEntity::getCustomerCode, (Object)customer.getCustomerCode())).set(MdmCustomerMsgEntity::getUserAccount, (Object)engineUserViewVo.getUserAccount())).set(MdmCustomerMsgEntity::getCustomerPrimary, (Object)(setPrimary ? YesOrNoEnum.YN.N.getCode() : YesOrNoEnum.YN.Y.getCode()))).update();
            setPrimary = true;
            if (!StringUtils.isNotEmpty((String)item.getRoleCode())) continue;
            EngineRoleCustomerEntity engineRoleCustomerEntity = new EngineRoleCustomerEntity();
            engineRoleCustomerEntity.setCustomerCode(customer.getCustomerCode());
            engineRoleCustomerEntity.setRoleCode(item.getRoleCode());
            engineRoleCustomerEntity.setId(item.getCustomerCode() + "" + item.getRoleCode());
            this.engineRoleCustomerService.save(engineRoleCustomerEntity);
        }
    }

    private void updateUserPositionRelation(EngineUserViewVo engineUserViewVo, EngineUserEntity userEntity) {
        ((LambdaUpdateChainWrapper)this.engineUserPositionService.lambdaUpdate().eq(EngineUserPositionEntity::getUserId, (Object)userEntity.getId())).remove();
        this.engineRoleUserService.removeUserAccount(userEntity.getUserAccount());
        for (EngineUserPositionVo item : engineUserViewVo.getEngineUserPositionVos()) {
            EnginePositionEntity position = null;
            if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                MdmPositionLevelReqVo positionLevelReqVo = new MdmPositionLevelReqVo();
                positionLevelReqVo.setPositionLevelCode(item.getPositionLevelCode());
                MdmPositionLevelRespVo positionLevel = this.mdmPositionLevelService.query(positionLevelReqVo);
                Assert.notNull((Object)positionLevel, (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
                position = new EnginePositionEntity();
                position.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
                position.setPositionName(this.generatePositionName(positionLevel.getPositionLevelCode(), positionLevel.getPositionLevelName()));
                position.setIsPrimary(item.getIsPrimary());
                position.setPositionLevelCode(positionLevel.getPositionLevelCode());
                position.setPositionLevelId(positionLevel.getId());
                this.enginePositionService.save((Object)position);
            } else if (PositionOperationEnum.HISTORY.getCode().equals(item.getOperationType())) {
                EngineUserEntity oldUser;
                EngineUserPositionEntity userPositionMapping;
                position = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionCode, (Object)item.getPositionCode())).one());
                Assert.notNull((Object)((Object)position), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
                if (Integer.valueOf(YesOrNoEnum.IO.YES.getCode()).equals(position.getIsPrimary()) && (userPositionMapping = (EngineUserPositionEntity)((LambdaQueryChainWrapper)this.engineUserPositionService.lambdaQuery().eq(EngineUserPositionEntity::getPositionId, (Object)position.getId())).one()) != null && (oldUser = (EngineUserEntity)((Object)this.getById((Serializable)((Object)userPositionMapping.getUserId())))) != null && !oldUser.getUserAccount().equals(userEntity.getUserAccount())) {
                    this.engineRoleUserService.removeUserAccount(oldUser.getUserAccount());
                }
                ((LambdaUpdateChainWrapper)this.engineUserPositionService.lambdaUpdate().eq(EngineUserPositionEntity::getPositionId, (Object)position.getId())).remove();
                ((LambdaUpdateChainWrapper)this.engineRolePositionService.lambdaUpdate().eq(EngineRolePositionEntity::getPositionCode, (Object)position.getPositionCode())).remove();
            } else {
                throw new BusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            EngineOrgEntity org = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)this.engineOrgService.lambdaQuery().eq(EngineOrgEntity::getOrgCode, (Object)item.getOrgCode())).one());
            Assert.notNull((Object)((Object)org), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            position.setOrganizationId(org.getId());
            if (StringUtils.isNotEmpty((String)item.getParentPositionCode())) {
                EnginePositionEntity parentPosition = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionCode, (Object)item.getParentPositionCode())).one());
                Assert.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                position.setParentId(parentPosition.getId());
            }
            position.setIsPrimary(item.getIsPrimary());
            this.enginePositionService.updateById((Object)position);
            EngineUserPositionEntity engineUserPositionEntity = new EngineUserPositionEntity();
            engineUserPositionEntity.setUserId(userEntity.getId());
            engineUserPositionEntity.setPositionId(position.getId());
            this.engineUserPositionService.save(engineUserPositionEntity);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getRoleCodeList())) continue;
            for (String roleCode : item.getRoleCodeList()) {
                EngineRolePositionEntity engineRolePositionEntity = new EngineRolePositionEntity();
                engineRolePositionEntity.setPositionCode(position.getPositionCode());
                engineRolePositionEntity.setRoleCode(roleCode);
                engineRolePositionEntity.setId(position.getPositionCode() + roleCode);
                this.engineRolePositionService.save(engineRolePositionEntity);
            }
            if (!Integer.valueOf(YesOrNoEnum.IO.YES.getCode()).equals(position.getIsPrimary())) continue;
            this.engineRoleUserService.saveUserRoles(userEntity.getUserAccount(), item.getRoleCodeList());
        }
    }

    private String generatePositionName(String positionLevelCode, String positionLevelName) {
        List enginePositionEntities = ((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionLevelCode, (Object)positionLevelCode)).list();
        if (CollectionUtils.isEmpty((Collection)enginePositionEntities)) {
            return positionLevelName + "_1";
        }
        Integer max = 1;
        for (EnginePositionEntity item : enginePositionEntities) {
            Integer cur;
            String[] array1 = item.getPositionName().split("[\\D]+");
            String s = array1[array1.length - 1];
            if (!StringUtils.isNotEmpty((String)s) || (cur = Integer.valueOf(s)) <= max) continue;
            max = cur;
        }
        return positionLevelName + "_" + (max + 1);
    }

    private String passwordEncrypt(String password) {
        return "68317e193f97a5a4c66a08a1f228259c1c66e36855bcae51d9f7db6c9e254eb47014dcf6208cb8a3";
    }
}

