/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.org.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTerminalRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.org.service.MdmOrgTerminalService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MdmOrgTerminalServiceImpl
implements MdmOrgTerminalService {
    @Resource
    private MdmTerminalService mdmTerminalService;

    @Override
    public PageResult<MdmOrgTerminalRespVo> findOrgTerminalList(MdmOrgTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmTerminalVo mdmTerminalVo = new MdmTerminalVo();
        mdmTerminalVo.setTerminalCode(reqVo.getTerminalCode());
        mdmTerminalVo.setTerminalName(reqVo.getTerminalName());
        mdmTerminalVo.setOrgCode(reqVo.getOrgCode());
        mdmTerminalVo.setPageNum(reqVo.getPageNum());
        mdmTerminalVo.setPageSize(reqVo.getPageSize());
        PageResult<MdmTerminalVo> terminalServicePage = this.mdmTerminalService.findList(mdmTerminalVo);
        if (terminalServicePage == null || CollectionUtils.isEmpty((Collection)terminalServicePage.getData())) {
            return PageResult.builder().data(Collections.emptyList()).count(terminalServicePage.getCount()).build();
        }
        List mdmOrgTerminalRespVos = CrmBeanUtil.copyList((List)terminalServicePage.getData(), MdmOrgTerminalRespVo.class);
        return PageResult.builder().data(mdmOrgTerminalRespVos).count(terminalServicePage.getCount()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo mdmOrgTerminalReqVo = new com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo();
        mdmOrgTerminalReqVo.setOrgCode(reqVo.getOrgCode());
        mdmOrgTerminalReqVo.setTerminalCodeList(reqVo.getTerminalCodeList());
        this.mdmTerminalService.batchUpdateTerminalOrg(mdmOrgTerminalReqVo);
    }
}

