/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionButtonStoreVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleSelectRespVo;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmRoleController"})
@Api(tags={"MDM-\u89d2\u8272\u7ba1\u7406"})
@CrmGlobalLog
public class MdmRoleController {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleController.class);
    @Resource
    private MdmRoleService mdmRoleService;

    @ApiOperation(value="\u5217\u8868\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmRoleRespVo>> pageList(@RequestBody MdmRoleReqVo mdmRoleReqVo) {
        PageResult<MdmRoleRespVo> data = this.mdmRoleService.findList(mdmRoleReqVo);
        return Result.ok(data);
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868\uff08\u4e0d\u9650\u5236\u6570\u91cf\uff0c\u4e00\u822c\u7528\u4e8e\u7a7f\u68ad\u6846\uff09")
    @PostMapping(value={"/roleList"})
    public Result<List<MdmRoleRespVo>> roleList(@RequestBody MdmRoleReqVo mdmRoleReqVo) {
        List<MdmRoleRespVo> data = this.mdmRoleService.roleList(mdmRoleReqVo);
        return Result.ok(data);
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868\uff08\u9650\u5236\u6570\u91cf\uff0c\u4e00\u822c\u7528\u4e8e\u4e0b\u62c9\u6846\uff09")
    @PostMapping(value={"/roleSelectList"})
    public Result<List<MdmRoleSelectRespVo>> roleSelectList(@RequestBody MdmRoleSelectReqVo reqVo) {
        return Result.ok(this.mdmRoleService.roleSelectList(reqVo));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmRoleRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="roleCode", required=false) String roleCode) {
        return Result.ok((Object)this.mdmRoleService.detail(id, roleCode));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmRoleReqVo mdmRoleReqVo) {
        this.mdmRoleService.save(mdmRoleReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmRoleReqVo mdmRoleReqVo) {
        this.mdmRoleService.update(mdmRoleReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody List<String> ids) {
        this.mdmRoleService.deleteBatch(new MdmRoleReqVo().setIds(ids));
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody List<String> ids) {
        this.mdmRoleService.enableBatch(new MdmRoleReqVo().setIds(ids));
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody List<String> ids) {
        this.mdmRoleService.disableBatch(new MdmRoleReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7684\u83dc\u5355\u6811")
    @PostMapping(value={"/roleFunctionTree"})
    public Result<MdmRoleFunctionRespVo> roleFunctionTree(@RequestBody MdmRoleFunctionReqVo mdmRoleFunctionReqVo) {
        MdmRoleFunctionRespVo data = this.mdmRoleService.roleFunctionTree(mdmRoleFunctionReqVo);
        return Result.ok((Object)data);
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7684\u5df2\u663e\u793a\u6309\u94ae")
    @PostMapping(value={"/roleButtonList"})
    public Result<List<MdmRoleSubButtonRespVo>> roleButtonList(@RequestBody MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo) {
        List<MdmRoleSubButtonRespVo> list = this.mdmRoleService.roleButtonList(mdmRoleSubButtonReqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u4e0e\u6309\u94ae")
    @PostMapping(value={"/saveFunctionButton"})
    public Result<Object> saveFunctionButton(@RequestBody MdmRoleFunctionButtonStoreVo mdmRoleFunctionButtonStoreVo) {
        this.mdmRoleService.saveFunctionButton(mdmRoleFunctionButtonStoreVo);
        return Result.ok();
    }
}

