/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmrole.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmBpmRoleController"})
@Api(tags={"MDM-\u6d41\u7a0b\u89d2\u8272"})
@CrmGlobalLog
public class MdmBpmRoleController {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleController.class);
    @Autowired
    private MdmBpmRoleService mdmBpmRoleService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmBpmRoleRespVo>> pageList(@RequestBody MdmBpmRoleReqVo reqVo) {
        PageResult<MdmBpmRoleRespVo> result = this.mdmBpmRoleService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u6216\u8005\u7f16\u7801\u83b7\u53d6\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="bpmRoleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmBpmRoleRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="bpmRoleCode", required=false) String bpmRoleCode) {
        return Result.ok((Object)this.mdmBpmRoleService.detail(id, bpmRoleCode));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmBpmRoleReqVo reqVo) {
        this.mdmBpmRoleService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmBpmRoleReqVo reqVo) {
        this.mdmBpmRoleService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmBpmRoleService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmBpmRoleService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmBpmRoleService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6d41\u7a0b\u89d2\u8272\u4e0b\u62c9\u6846(\u9650\u5236\u6570\u91cf)")
    @PostMapping(value={"/selectList"})
    public Result<List<MdmBpmRoleSelectRespVo>> selectList(@RequestBody MdmBpmRoleSelectReqVo reqVo) {
        return Result.ok(this.mdmBpmRoleService.selectList(reqVo));
    }
}

