/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.manager.MdmCustomerMsgBuilder;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.role.mode.MdmRoleCustomerEntity;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerMsgServiceExpandImpl"})
public class MdmCustomerMsgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerMsgMapper, MdmCustomerEntity>
implements MdmCustomerMsgService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgServiceImpl.class);
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmCustomerContactService mdmCustomerContactService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerSaleAreaService mdmCustomerSaleAreaService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmRoleCustomerService mdmRoleCustomerService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> orgCodeList;
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        if (!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCode())) {
            orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getCode());
            if (!CollectionUtils.isEmpty(orgCodeList)) {
                List<String> customerCodeList = this.mdmCustomerROrgService.findCustomerByOrgCodeList(orgCodeList);
                if (CollectionUtils.isEmpty(customerCodeList)) {
                    return PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(page.getTotal())).build();
                }
                mdmCustomerMsgReqVo.setCustomerCodeList(customerCodeList);
            }
        } else if (!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode()) && !CollectionUtils.isEmpty(orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getOrgCode()))) {
            List<String> customerCodeList = this.mdmCustomerROrgService.findCustomerByOrgCodeList(orgCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(page.getTotal())).build();
            }
            mdmCustomerMsgReqVo.setCustomerCodeList(customerCodeList);
        }
        List<MdmCustomerMsgRespVo> list = this.mdmCustomerMsgMapper.findList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerMsgReqVo);
        this.setUpOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setUpOrgName(List<MdmCustomerMsgRespVo> list) {
        List<String> orgCodeList;
        Map<String, String> orgNameMap;
        Map<String, List<String>> customerOrgMap;
        List<String> customerCodeList;
        if (!(CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(customerCodeList = list.stream().filter(x -> !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList())) || ObjectUtils.isEmpty(customerOrgMap = this.mdmCustomerROrgService.findOrgCodeList(customerCodeList)) || ObjectUtils.isEmpty(orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList = customerOrgMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()))))) {
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : list) {
                List<String> currentOrgCodeList = customerOrgMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                String orgName = currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((String)x)).distinct().map(orgNameMap::get).collect(Collectors.joining(","));
                mdmCustomerMsgRespVo.setOrgName(orgName);
                mdmCustomerMsgRespVo.setOrgCode(currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((String)x)).distinct().collect(Collectors.joining(",")));
            }
        }
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmCustomerMsgReqVo.getEnableStatus())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getLockState()), MdmCustomerEntity::getLockState, (Object)mdmCustomerMsgReqVo.getLockState())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).like(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).like(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerName()), MdmCustomerEntity::getCustomerName, (Object)mdmCustomerMsgReqVo.getCustomerName())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode()), MdmCustomerEntity::getOrgCode, (Object)mdmCustomerMsgReqVo.getOrgCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerOrgCode()), MdmCustomerEntity::getCustomerOrgCode, (Object)mdmCustomerMsgReqVo.getCustomerOrgCode())).in(!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getCustomerCodeList()), MdmCustomerEntity::getCustomerCode, (Collection)mdmCustomerMsgReqVo.getCustomerCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, CrmBaseEntity::getEnableStatus, MdmCustomerEntity::getLockState}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerMsgSelectRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgSelectReqVo reqVo) {
        List<MdmCustomerMsgSelectRespVo> selectedList;
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmCustomerMsgSelectRespVo> list = new ArrayList<MdmCustomerMsgSelectRespVo>();
        ArrayList<String> codeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(codeList) && CollectionUtil.listNotEmptyNotSizeZero(selectedList = this.mdmCustomerMsgMapper.findCustomerSelectList((Page<MdmCustomerMsgSelectRespVo>)new Page(1L, (long)codeList.size(), false), reqVo, codeList, null))) {
            list.addAll(selectedList);
            pageSize = pageSize - selectedList.size();
        }
        if (pageSize > 0) {
            list.addAll(this.mdmCustomerMsgMapper.findCustomerSelectList((Page<MdmCustomerMsgSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, codeList));
        }
        return list;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return this.mdmCustomerMsgMapper.findCustomerNotRelateUserSelectList(null, mdmCustomerMsgReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getOrgCode, list)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public MdmCustomerMsgRespVo query(String id, String customerCode) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCode(customerCode);
        mdmCustomerMsgReqVo.setId(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgMapper.query(mdmCustomerMsgReqVo);
        return Optional.ofNullable(mdmCustomerMsgRespVo).map(x -> {
            this.setUpCustomer(mdmCustomerMsgRespVo);
            this.setUpOrgName(Collections.singletonList(mdmCustomerMsgRespVo));
            return mdmCustomerMsgRespVo;
        }).orElse(null);
    }

    protected void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        Map map = DictUtil.dictMap((String)"customer_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            mdmCustomerMsgRespVo.setMdmCustomerContactVos(this.mdmCustomerContactService.list(new MdmCustomerContactReqVo().setCustomerCode(customerCode)));
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("extended_information"))) {
            mdmCustomerMsgRespVo.setMdmCustomerDockingVos(this.mdmCustomerSupplyService.findDockingListByCustomerCode(new MdmCustomerDockingReqVo().setCustomerCode(customerCode)));
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("sales_area"))) {
            mdmCustomerMsgRespVo.setMdmCustomerSaleAreaVos(this.mdmCustomerSaleAreaService.listCondition(new MdmCustomerSaleAreaReqVo().setCustomerCode(customerCode)));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Map map = DictUtil.dictMap((String)"customer_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            this.mdmCustomerContactService.setUpContact(mdmCustomerMsgReqVo.getMdmCustomerContactVos(), mdmCustomerMsgReqVo.getCustomerCode());
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("extended_information"))) {
            this.mdmCustomerSupplyService.setUpDocking(mdmCustomerMsgReqVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("sales_area"))) {
            this.mdmCustomerSaleAreaService.setUpArea(mdmCustomerMsgReqVo.getMdmCustomerSaleAreaVos(), mdmCustomerMsgReqVo.getCustomerCode());
        }
        this.mdmCustomerROrgService.setUpOrg(mdmCustomerMsgReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgBuilder.builder(true, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
        return mdmCustomerMsgReqVo.getCustomerCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgBuilder.builder(false, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getUserName}).list();
        Assert.notEmpty((Collection)list, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        List<String> customerCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        List<String> userNameList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getUserName())).map(MdmCustomerEntity::getUserName).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            ((LambdaUpdateChainWrapper)this.mdmCustomerROrgService.lambdaUpdate().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).remove();
            ((LambdaUpdateChainWrapper)this.mdmCustomerSaleAreaService.lambdaUpdate().in(MdmCustomerSaleAreaEntity::getCustomerCode, customerCodeList)).remove();
            this.mdmCustomerSupplyService.removeByCustomerCodeList(customerCodeList);
            ((LambdaUpdateChainWrapper)this.mdmCustomerContactService.lambdaUpdate().in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)).remove();
        }
        this.removeByIds(ids);
        this.mdmUserService.updateUserCustomerRedundancyByUser(null, userNameList);
        this.sendCustomerChangeMsg(customerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        if (!CollectionUtils.isEmpty(mdmCustomerContactReqVos)) {
            this.mdmCustomerContactService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmCustomerContactReqVos, MdmCustomerContactEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        List customerCodeList = mdmUpdateCusOrgCodeReqVo.getCustomerCodeList();
        String customerOrgCode = mdmUpdateCusOrgCodeReqVo.getCustomerOrgCode();
        if (CollectionUtils.isEmpty((Collection)customerCodeList) || StringUtils.isEmpty((String)customerOrgCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u6216\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerEntity::getCustomerCode, (Collection)customerCodeList)).set(MdmCustomerEntity::getCustomerOrgCode, (Object)customerOrgCode)).update();
        this.sendCustomerChangeMsg(customerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        if (StringUtils.isNotEmpty((String)reqVo.getOriginOrgCode())) {
            this.mdmCustomerROrgService.replaceOrg(reqVo.getCustomerCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            this.mdmCustomerROrgService.setUpOrg(reqVo.getCustomerCodeList(), reqVo.getOrgCode());
        }
        this.sendCustomerChangeMsg(reqVo.getCustomerCodeList());
    }

    @Override
    public Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode));
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByCustomerCodeList(List<String> customerCodeList) {
        return this.mdmCustomerROrgService.findOrgCodeList(customerCodeList);
    }

    @Override
    public List<String> findAllCustomerCodeByUser(String userAccount) {
        if (StringUtils.isEmpty((String)userAccount)) {
            return Collections.emptyList();
        }
        return this.mdmCustomerMsgMapper.findAllCustomerCodeByUser(userAccount);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<MdmOrgRespVo> orgRespVos;
        List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList) && !CollectionUtils.isEmpty(orgRespVos = this.mdmOrgService.findAllChildrenOrgListByList(null, mdmCustomerOrgSearchReqVo.getOrgCodeList()))) {
            List<String> relationOrgCodeList = orgRespVos.stream().map(MdmOrgRespVo::getOrgCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(relationOrgCodeList)) {
                return Collections.emptyList();
            }
            List<String> customerCodeList = this.mdmCustomerROrgService.findCustomerByOrgCodeList(relationOrgCodeList);
            mdmCustomerOrgSearchReqVo.setCustomerCodeList(customerCodeList);
        }
        return this.mdmCustomerMsgMapper.listCondition(mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        if (CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList()) && CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            return Lists.newArrayList();
        }
        ArrayList merge = Lists.newArrayList();
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList())) {
            merge.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getChannel, (Collection)customerCodeConditionReqVo.getChannelList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            merge.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getOrgCode, (Collection)customerCodeConditionReqVo.getOrgCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        return merge.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return this.mdmCustomerMsgMapper.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public List<MdmCustomerMsgRespVo> queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getUserName()), MdmCustomerEntity::getUserName, (Object)mdmCustomerMsgReqVo.getUserName())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerPrimary()), MdmCustomerEntity::getCustomerPrimary, (Object)mdmCustomerMsgReqVo.getCustomerPrimary())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmCustomerMsgReqVo.getEnableStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerMsgRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        String positionCode = mdmPositionCustomerSearchReqVo.getPositionCode();
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmPositionCustomerSearchReqVo.setPositionCodeList(this.mdmPositionService.findAllChildrenPositionCodeList(null, positionCode));
        return this.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTopic(this.topic);
            rocketMQMessageBody.setTag("CUS_AVAILBLELIST_REFRSH");
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(customerCodeList));
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        String positionCode = mdmCustomerContactPageReqVo.getPositionCode();
        if (!StringUtils.isEmpty((String)positionCode)) {
            List<String> customerCodeList = this.mdmCustomerSupplyService.findCustomerCodeByPosition(Collections.singletonList(positionCode));
            log.info("\u5ba2\u6237\u4fe1\u606f\uff1a\u5173\u8054\u804c\u4f4d\u7684\u5ba2\u6237:{}", customerCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(0L)).build();
            }
            mdmCustomerContactPageReqVo.setCustomerCodeList(customerCodeList);
        }
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        mdmCustomerMsgRespVos.stream().forEach(mdm -> mdm.setCustomerCategory("\u7ecf\u9500\u5546"));
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Assert.hasText((String)mdmCustomerDockingReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> list = this.mdmCustomerSupplyService.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        if (CollectionUtils.isEmpty(mdmCustomerMsgReqVos)) {
            return;
        }
        for (MdmCustomerMsgReqVo mdmCustomerMsgReqVo : mdmCustomerMsgReqVos) {
            String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
            if (StringUtils.isEmpty((String)customerCode)) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmCustomerEntity::getLongitude, (Object)mdmCustomerMsgReqVo.getLongitude())).set(MdmCustomerEntity::getLatitude, (Object)mdmCustomerMsgReqVo.getLatitude())).update();
        }
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerListByUserName(String userName) {
        List customerEntityList;
        ArrayList<MdmCustomerMsgRespVo> list = new ArrayList<MdmCustomerMsgRespVo>();
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getUserName, (Object)userName)).list()))) {
            Map<Object, Object> customerRoleListMap = new HashMap(16);
            List roleCustomerEntityList = ((LambdaQueryChainWrapper)this.mdmRoleCustomerService.lambdaQuery().in(MdmRoleCustomerEntity::getCustomerCode, (Collection)customerEntityList.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()))).list();
            Map<Object, Object> roleTempMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCustomerEntityList)) {
                customerRoleListMap = roleCustomerEntityList.stream().collect(Collectors.groupingBy(MdmRoleCustomerEntity::getCustomerCode));
                List roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)roleCustomerEntityList.stream().map(MdmRoleCustomerEntity::getRoleCode).distinct().collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list();
                roleTempMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v));
            }
            HashMap finalMap = customerRoleListMap;
            HashMap finalRoleMap = roleTempMap;
            list.addAll(customerEntityList.stream().map(item -> {
                MdmCustomerMsgRespVo copy = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                ArrayList roleList = new ArrayList();
                if (finalMap.containsKey(item.getCustomerCode())) {
                    List itemRoleCustomerEntityList = (List)finalMap.get(item.getCustomerCode());
                    for (MdmRoleCustomerEntity roleCustItem : itemRoleCustomerEntityList) {
                        if (!finalRoleMap.containsKey(roleCustItem.getRoleCode())) continue;
                        roleList.add(finalRoleMap.get(roleCustItem.getRoleCode()));
                    }
                }
                copy.setRoleCode(roleList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.joining(",")));
                copy.setRoleName(roleList.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.joining(",")));
                return copy;
            }).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public MdmCustomerMsgRespVo getUserCurrentCustomer(String userName) {
        List customerList;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getUserName, (Object)userName)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list()))) {
            List primaryList = customerList.stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getCustomerPrimary())).collect(Collectors.toList());
            if (primaryList.size() == 1) {
                return (MdmCustomerMsgRespVo)CrmBeanUtil.copy(primaryList.get(0), MdmCustomerMsgRespVo.class);
            }
            MdmCustomerEntity mdmCustomerEntity = (MdmCustomerEntity)((Object)customerList.get(0));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getUserName, (Object)userName)).ne(MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerEntity.getCustomerCode())).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ZERO)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerEntity.getCustomerCode())).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
            MdmCustomerMsgRespVo copy = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)((Object)mdmCustomerEntity), MdmCustomerMsgRespVo.class);
            copy.setCustomerPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
            return copy;
        }
        return null;
    }

    @Override
    public void frozen(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public void thaw(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public Integer findPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0;
        }
        List positionCodeList = position.stream().filter(x -> !StringUtils.isEmpty((String)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getPositionCode, positionCodeList)).count();
    }

    @Override
    public Integer findCurrentPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().eq(MdmCustomerSupplyEntity::getPositionCode, (Object)positionCode)).count();
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerDistanceContactPageReqVo.getPageNum(), (Integer)mdmCustomerDistanceContactPageReqVo.getPageSize());
        String customerScopeType = mdmCustomerDistanceContactPageReqVo.getCustomerScopeType();
        PageResult emptyPage = PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(0L)).build();
        if (!StringUtils.isEmpty((String)customerScopeType)) {
            String positionCode = Optional.ofNullable(UserUtils.getUser()).filter(x -> !StringUtils.isEmpty((String)x.getPoscode())).map(UserRedis::getPoscode).orElse(null);
            if (StringUtils.isEmpty((String)positionCode)) {
                log.error("\u7528\u6237\u4f1a\u8bdd\u5f02\u5e38:{}", (Object)UserUtils.getUser());
                return emptyPage;
            }
            ArrayList<String> positionCodeList = new ArrayList<String>();
            switch (customerScopeType) {
                case "1": {
                    List<MdmPositionRespVo> allChildrenPositionList = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
                    log.info("\u5f53\u524d\u53ca\u4e0b\u5c5e\u804c\u4f4d:{}", allChildrenPositionList);
                    if (CollectionUtils.isEmpty(allChildrenPositionList)) break;
                    List collect = allChildrenPositionList.stream().filter(x -> !StringUtils.isEmpty((String)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
                    positionCodeList.addAll(collect);
                    break;
                }
                case "2": {
                    positionCodeList.add(positionCode);
                    break;
                }
                case "3": {
                    List<MdmPositionRespVo> childrenPositionList = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
                    log.info("\u5f53\u524d\u53ca\u4e0b\u5c5e\u804c\u4f4d:{}", childrenPositionList);
                    if (CollectionUtils.isEmpty(childrenPositionList)) break;
                    List collect = childrenPositionList.stream().filter(x -> !StringUtils.isEmpty((String)x.getPositionCode())).filter(x -> !positionCode.equals(x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
                    positionCodeList.addAll(collect);
                    break;
                }
            }
            List<String> customerCodeList = this.mdmCustomerSupplyService.findCustomerCodeByPosition(positionCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return emptyPage;
            }
        }
        List<MdmCustomerContactPageRespVo> list = this.mdmCustomerMsgMapper.distanceContactPage((Page<MdmCustomerContactPageRespVo>)page, mdmCustomerDistanceContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

