/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupRelFieldReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceOperationCheckRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupEntity;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupRelFieldService;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupService;
import com.biz.crm.pricesetting.service.MdmPriceConditionTypeRelGroupService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPriceConditionGroupServiceExpandImpl"})
public class MdmPriceConditionGroupServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceConditionGroupMapper, MdmPriceConditionGroupEntity>
implements MdmPriceConditionGroupService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceConditionGroupServiceImpl.class);
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;
    @Resource
    private MdmPriceConditionTypeRelGroupService mdmPriceConditionTypeRelGroupService;

    @Override
    public PageResult<MdmPriceConditionGroupRespVo> findList(MdmPriceConditionGroupReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPriceConditionGroupRespVo> list = this.mdmPriceConditionGroupMapper.findList((Page<MdmPriceConditionGroupRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPriceConditionGroupRespVo query(String id, String conditionGroupCode) {
        MdmPriceConditionGroupEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)conditionGroupCode)) && (one = (MdmPriceConditionGroupEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)conditionGroupCode), MdmPriceConditionGroupEntity::getConditionGroupCode, (Object)conditionGroupCode)).one())) != null) {
            MdmPriceConditionGroupRespVo respVo = (MdmPriceConditionGroupRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmPriceConditionGroupRespVo.class);
            List list = ((LambdaQueryChainWrapper)this.mdmPriceConditionGroupRelFieldService.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)one.getConditionGroupCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                respVo.setConditionFieldList(CrmBeanUtil.copyList((List)list, MdmPriceConditionGroupRelFieldRespVo.class));
            }
            return respVo;
        }
        return null;
    }

    @Override
    public MdmPriceOperationCheckRespVo editCheck(String id) {
        MdmPriceOperationCheckRespVo respVo = new MdmPriceOperationCheckRespVo();
        respVo.setEditCheck(Boolean.valueOf(true));
        Assert.hasText((String)id, (String)"\u7f3a\u5931\u53c2\u6570");
        MdmPriceConditionGroupEntity entity = (MdmPriceConditionGroupEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
        List relList = ((LambdaQueryChainWrapper)this.mdmPriceConditionTypeRelGroupService.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode, (Object)entity.getConditionGroupCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)relList)) {
            respVo.setEditCheck(Boolean.valueOf(false));
            respVo.setMessage("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e3a" + entity.getConditionGroupCode() + "\u7684\u6570\u636e\u5173\u8054\u4e86\u6761\u4ef6\u7c7b\u578b\uff0c\u4e0d\u53ef\u7f16\u8f91");
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceConditionGroupReqVo reqVo) {
        reqVo.setId(null);
        Assert.notEmpty((Collection)reqVo.getConditionFieldList(), (String)"\u8bf7\u9009\u62e9\u6761\u4ef6\u5206\u7c7b\u63cf\u8ff0");
        if (StringUtils.isNotEmpty((String)reqVo.getConditionGroupCode())) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPriceConditionGroupEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        Map priceConditionMap = DictUtil.dictMap((String)"price_condition");
        reqVo.getConditionFieldList().forEach(item -> {
            Assert.hasText((String)item.getFieldCode(), (String)"\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u7f3a\u5931");
            Assert.isTrue((boolean)priceConditionMap.containsKey(item.getFieldCode()), (String)"\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u65e0\u6548");
            item.setFieldName((String)priceConditionMap.get(item.getFieldCode()));
        });
        Assert.isTrue((boolean)reqVo.getConditionFieldList().stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldCode).collect(Collectors.toSet()).contains(PriceSettingFieldEnum.PRODUCT_CODE.getCode()), (String)("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u5fc5\u987b\u9009\u62e9" + PriceSettingFieldEnum.PRODUCT_CODE.getDes()));
        List sortedList = reqVo.getConditionFieldList().stream().sorted(Comparator.comparing(MdmPriceConditionGroupRelFieldReqVo::getFieldCode)).collect(Collectors.toList());
        String groupCodesKey = sortedList.stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldCode).collect(Collectors.joining("/"));
        String conditionGroupDesc = sortedList.stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldName).collect(Collectors.joining("/"));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPriceConditionGroupEntity::getGroupCodesKey, (Object)groupCodesKey)).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)("\u7ec4\u5408" + conditionGroupDesc + "\u5df2\u7ecf\u5b58\u5728"));
        reqVo.setGroupCodesKey(groupCodesKey);
        reqVo.setConditionGroupDesc(conditionGroupDesc);
        MdmPriceConditionGroupEntity entity = (MdmPriceConditionGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceConditionGroupEntity.class));
        if (StringUtils.isEmpty((String)entity.getConditionGroupCode())) {
            entity.setConditionGroupCode(CodeUtil.createOneCode((String)"mdm_price_condition_group"));
        }
        this.save((Object)entity);
        reqVo.getConditionFieldList().forEach(item -> item.setConditionGroupCode(entity.getConditionGroupCode()));
        this.mdmPriceConditionGroupRelFieldService.saveBatch(CrmBeanUtil.copyList((List)reqVo.getConditionFieldList(), MdmPriceConditionGroupRelFieldEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceConditionGroupReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        MdmPriceConditionGroupEntity entity = (MdmPriceConditionGroupEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u6761\u4ef6\u5206\u7c7b");
        List relList = ((LambdaQueryChainWrapper)this.mdmPriceConditionTypeRelGroupService.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode, (Object)entity.getConditionGroupCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)relList), (String)"\u8be5\u6761\u4ef6\u5206\u7c7b\u5df2\u7ecf\u5173\u8054\u4e86\u6761\u4ef6\u7c7b\u578b\uff0c\u4e0d\u80fd\u7f16\u8f91");
        Assert.hasText((String)reqVo.getConditionGroupCode(), (String)"\u7f3a\u5931\u6761\u4ef6\u7c7b\u578b\u7f16\u7801");
        Assert.isTrue((boolean)entity.getConditionGroupCode().equals(reqVo.getConditionGroupCode()), (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        Assert.notEmpty((Collection)reqVo.getConditionFieldList(), (String)"\u8bf7\u9009\u62e9\u6761\u4ef6\u5206\u7c7b\u63cf\u8ff0");
        Map priceConditionMap = DictUtil.dictMap((String)"price_condition");
        reqVo.getConditionFieldList().forEach(item -> {
            Assert.hasText((String)item.getFieldCode(), (String)"\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u7f3a\u5931");
            Assert.isTrue((boolean)priceConditionMap.containsKey(item.getFieldCode()), (String)"\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u65e0\u6548");
            item.setFieldName((String)priceConditionMap.get(item.getFieldCode()));
        });
        Assert.isTrue((boolean)reqVo.getConditionFieldList().stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldCode).collect(Collectors.toSet()).contains(PriceSettingFieldEnum.PRODUCT_CODE.getCode()), (String)("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u5fc5\u987b\u9009\u62e9" + PriceSettingFieldEnum.PRODUCT_CODE.getDes()));
        List sortedList = reqVo.getConditionFieldList().stream().sorted(Comparator.comparing(MdmPriceConditionGroupRelFieldReqVo::getFieldCode)).collect(Collectors.toList());
        String groupCodesKey = sortedList.stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldCode).collect(Collectors.joining("/"));
        String conditionGroupDesc = sortedList.stream().map(MdmPriceConditionGroupRelFieldReqVo::getFieldName).collect(Collectors.joining("/"));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPriceConditionGroupEntity::getGroupCodesKey, (Object)groupCodesKey)).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)("\u7ec4\u5408" + conditionGroupDesc + "\u5df2\u7ecf\u5b58\u5728"));
        reqVo.setGroupCodesKey(groupCodesKey);
        reqVo.setConditionGroupDesc(conditionGroupDesc);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        ((LambdaUpdateChainWrapper)this.mdmPriceConditionGroupRelFieldService.lambdaUpdate().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)entity.getConditionGroupCode())).remove();
        reqVo.getConditionFieldList().forEach(item -> item.setConditionGroupCode(entity.getConditionGroupCode()));
        this.mdmPriceConditionGroupRelFieldService.saveBatch(CrmBeanUtil.copyList((List)reqVo.getConditionFieldList(), MdmPriceConditionGroupRelFieldEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmPriceConditionGroupEntity::getConditionGroupCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> {
                List typeRelGroupList = ((LambdaQueryChainWrapper)this.mdmPriceConditionTypeRelGroupService.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode, (Object)item.getConditionGroupCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)typeRelGroupList), (String)("\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u4e3a{" + item.getConditionGroupCode() + "}\u7684\u6570\u636e\u5173\u8054\u4e86\u6761\u4ef6\u7c7b\u578b\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            });
            this.removeByIds(ids);
            ((LambdaUpdateChainWrapper)this.mdmPriceConditionGroupRelFieldService.lambdaUpdate().in(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Collection)list.stream().map(MdmPriceConditionGroupEntity::getConditionGroupCode).collect(Collectors.toList()))).remove();
        }
    }

    @Override
    public List<MdmPriceConditionGroupRespVo> findCollection(MdmPriceConditionGroupReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(StringUtils.isNotEmpty((String)reqVo.getConditionGroupCode()), MdmPriceConditionGroupEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode())).like(StringUtils.isNotEmpty((String)reqVo.getConditionGroupDesc()), MdmPriceConditionGroupEntity::getConditionGroupDesc, (Object)reqVo.getConditionGroupDesc())).select(new SFunction[]{BaseIdEntity::getId, MdmPriceConditionGroupEntity::getConditionGroupCode, MdmPriceConditionGroupEntity::getConditionGroupDesc}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmPriceConditionGroupRespVo.class);
        }
        return new ArrayList<MdmPriceConditionGroupRespVo>();
    }

    @Override
    public Map<String, String> getGroupMap() {
        return this.getGroupMap(new ArrayList<String>());
    }

    @Override
    public Map<String, String> getGroupMap(List<String> conditionGroupCodeList) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(conditionGroupCodeList), MdmPriceConditionGroupEntity::getConditionGroupCode, conditionGroupCodeList)).select(new SFunction[]{MdmPriceConditionGroupEntity::getConditionGroupCode, MdmPriceConditionGroupEntity::getConditionGroupDesc}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return list.stream().collect(Collectors.toMap(MdmPriceConditionGroupEntity::getConditionGroupCode, MdmPriceConditionGroupEntity::getConditionGroupDesc));
        }
        return new HashMap<String, String>();
    }
}

