/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingParentSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUnderlingRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUnderlingService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmPositionUnderlingServiceImpl
implements MdmPositionUnderlingService {
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    public PageResult<MdmPositionUnderlingRespVo> findPositionUnderlingList(MdmPositionUnderlingReqVo reqVo) {
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u5fc5\u4f20");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<String> positionCodeList = Collections.singletonList(reqVo.getPositionCode());
        reqVo.setPositionCode(null);
        List<MdmPositionUnderlingRespVo> list = this.mdmPositionMapper.findPositionUnderlingList((Page<MdmPositionUnderlingRespVo>)page, reqVo, positionCodeList);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceParentPosition(MdmPositionUnderlingReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getUnderlingPositionCodeList(), (String)"\u8bf7\u9009\u62e9\u4e0b\u7ea7\u804c\u4f4d");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u8bf7\u9009\u62e9\u4e0a\u7ea7\u804c\u4f4d");
        MdmPositionEntity parentPosition = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one());
        Assert.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
        List<MdmPositionRespVo> parentList = this.mdmPositionService.findAllParentPositionList(parentPosition.getId(), null);
        List parentCodeList = parentList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        reqVo.getUnderlingPositionCodeList().forEach(positionCode -> {
            Assert.hasText((String)positionCode, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionEntity position = (MdmPositionEntity)((Object)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, positionCode)).one()));
            Assert.notNull((Object)((Object)position), (String)("\u65e0\u6548\u7684\u4e0b\u7ea7\u804c\u4f4d" + positionCode));
            Assert.isTrue((!parentCodeList.contains(positionCode) ? 1 : 0) != 0, (String)("\u6240\u9009\u804c\u4f4d" + parentPosition.getPositionName() + "\u662f" + position.getPositionName() + "\u7684\u4e0b\u7ea7\u804c\u4f4d\uff0c\u4e0d\u80fd\u9009\u62e9\u4f5c\u4e3a\u4e0a\u7ea7"));
            this.mdmPositionService.changePositionParent((String)positionCode, reqVo.getPositionCode());
        });
    }

    @Override
    public PageResult<MdmPositionUserOrgPageRespVo> findPositionUnderlingParentSelectPageList(MdmPositionUnderlingParentSelectReqVo reqVo) {
        Set collect;
        Assert.notEmpty((Collection)reqVo.getExcludeChildPositionCodeList(), (String)"\u7f3a\u5931\u4e0b\u7ea7\u804c\u4f4d");
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        HashSet excludeOrgCodeList = new HashSet(16);
        List<MdmPositionRespVo> childrenPositionList = this.mdmPositionService.findAllChildrenPositionListByList(null, reqVo.getExcludeChildPositionCodeList());
        if (CollectionUtil.listNotEmptyNotSizeZero(childrenPositionList) && !(collect = childrenPositionList.stream().map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet())).isEmpty()) {
            List<MdmOrgRespVo> childrenOrgList = this.mdmOrgService.findAllChildrenOrgListByList(null, new ArrayList<String>(collect));
            Set childrenCodeSet = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toSet());
            excludeOrgCodeList.addAll(childrenOrgList.stream().filter(item -> childrenCodeSet.contains(item.getParentCode())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList()));
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionUserOrgPageRespVo> list = this.mdmPositionMapper.findPositionUnderlingParentSelectPageList((Page<MdmPositionUserOrgPageRespVo>)page, reqVo, new ArrayList<String>(excludeOrgCodeList));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

