/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.button.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.button.mapper.MdmButtonMapper;
import com.biz.crm.button.model.MdmButtonEntity;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.icon.service.IMdmIconService;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmButtonServiceExpandImpl"})
public class MdmButtonServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmButtonMapper, MdmButtonEntity>
implements MdmButtonService {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonServiceImpl.class);
    @Resource
    private MdmButtonMapper mdmButtonMapper;
    @Resource
    private IMdmIconService mdmIconService;

    @Override
    public PageResult<MdmButtonRespVo> findList(MdmButtonReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmButtonRespVo> list = this.mdmButtonMapper.findList((Page<MdmButtonRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmButtonRespVo query(String id, String buttonCode) {
        if (StringUtils.isEmpty((Object)id) && StringUtils.isEmpty((Object)buttonCode)) {
            return null;
        }
        MdmButtonEntity one = (MdmButtonEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((Object)buttonCode), MdmButtonEntity::getButtonCode, (Object)buttonCode)).one());
        return (MdmButtonRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmButtonRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmButtonReqVo reqVo) {
        this.valid(reqVo);
        this.validIcon(reqVo);
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u6309\u94ae\u7f16\u7801\u91cd\u590d");
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmButtonEntity.class));
    }

    protected void validIcon(MdmButtonReqVo reqVo) {
        String iconCode = reqVo.getIconCode();
        if (!StringUtils.isEmpty((Object)iconCode)) {
            MdmIconRespVo mdmIconRespVo = this.mdmIconService.query(null, iconCode);
            Assert.notNull((Object)mdmIconRespVo, (String)"\u56fe\u6807\u4e0d\u5b58\u5728");
        }
    }

    protected void valid(MdmButtonReqVo reqVo) {
        String buttonCode = reqVo.getButtonCode();
        Assert.hasText((String)buttonCode, (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String buttonName = reqVo.getButtonName();
        Assert.hasText((String)buttonName, (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmButtonReqVo reqVo) {
        this.valid(reqVo);
        this.validIcon(reqVo);
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)this.getById((Serializable)((Object)id)), (String)"\u6309\u94ae\u4e0d\u5b58\u5728");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)reqVo.getId())).eq(MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u6309\u94ae\u7f16\u7801\u91cd\u590d");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmButtonEntity.class));
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).remove();
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    public List<MdmButtonRespVo> listCondition(MdmButtonReqVo mdmButtonReqVo) {
        return this.mdmButtonMapper.listCondition(mdmButtonReqVo);
    }
}

