/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmSetVal;
import com.biz.crm.util.Result;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BeanUtil
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFieldValue(Object o) {
        if (o instanceof Result) {
            Object data = ((Result)o).getResult();
            if (data.getClass().isArray() || data instanceof Collection) {
                for (Object datum : (Collection)data) {
                    this.convertData(datum);
                }
            } else if (data instanceof PageResult) {
                List innerData = ((PageResult)data).getData();
                for (Object obj : innerData) {
                    this.convertData(obj);
                }
            } else {
                this.convertData(data);
            }
        }
    }

    private void convertData(Object o) {
        for (Class<?> sourceClass = o.getClass(); sourceClass != Object.class; sourceClass = sourceClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = sourceClass.getDeclaredFields()) {
                CrmSetVal crmSetVal = field.getAnnotation(CrmSetVal.class);
                if (crmSetVal == null) continue;
                field.setAccessible(true);
                String fieldNames = crmSetVal.paramField();
                String[] split = fieldNames.split(",");
                Class[] paramFieldTypeList = new Class[split.length];
                Object[] paramFieldValList = new Object[split.length];
                for (int i = 0; i < split.length; ++i) {
                    String fieldName = split[i];
                    Field paramField = sourceClass.getDeclaredField(fieldName);
                    paramField.setAccessible(true);
                    paramFieldTypeList[i] = paramField.getType();
                    paramFieldValList[i] = paramField.get(o);
                }
                Class<?> targetClass = Class.forName(crmSetVal.targetClass());
                Method targetMethod = targetClass.getDeclaredMethod(crmSetVal.targetMethod(), paramFieldTypeList);
                Object invoke = targetMethod.invoke(null, paramFieldValList);
                if (invoke == null) continue;
                field.set(o, invoke);
            }
        }
    }
}

