/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.customer.mapper.MdmCustomerSupplyMapper;
import com.biz.crm.customer.model.MdmCustomerSupplyDetailEntity;
import com.biz.crm.customer.service.IMdmCustomerSupplyDetailService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSupplyDetailReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSupplyDetailRespVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionCustomerServiceExpandImpl"})
public class MdmCustomerSupplyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerSupplyMapper, MdmCustomerSupplyEntity>
implements MdmCustomerSupplyService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerSupplyServiceImpl.class);
    @Autowired
    private MdmCustomerSupplyMapper mdmCustomerSupplyMapper;
    @Autowired
    private IMdmCustomerSupplyDetailService mdmCustomerSupplyDetailService;
    @Autowired
    private MdmPositionService mdmPositionService;

    @Override
    public List<String> findCustomerCodeByPosition(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerSupplyEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmCustomerSupplyEntity::getCustomerCode}).list().stream().filter(x -> !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerSupplyEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelation(String customerCode, String positionCode) {
        List list;
        if (StringUtils.isNotEmpty((String)customerCode) && StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerSupplyEntity::getCustomerCode, (Object)customerCode)).eq(MdmCustomerSupplyEntity::getPositionCode, (Object)positionCode)).list()))) {
            MdmCustomerSupplyEntity entity = new MdmCustomerSupplyEntity();
            entity.setCustomerCode(customerCode);
            entity.setPositionCode(positionCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelation(String customerCode, String positionCode, String orgCode) {
        MdmCustomerSupplyEntity entity = new MdmCustomerSupplyEntity();
        entity.setCustomerCode(customerCode);
        entity.setPositionCode(positionCode);
        entity.setOrgCode(orgCode);
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replacePosition(List<String> ids, String positionCode) {
        MdmPositionEntity one;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode) && (one = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getOrgCode}).one())) != null) {
            this.replacePosition(ids, positionCode, one.getOrgCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replacePosition(List<String> ids, String positionCode, String orgCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerSupplyEntity::getPositionCode, (Object)positionCode)).set(MdmCustomerSupplyEntity::getOrgCode, (Object)orgCode)).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelations(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            this.removeByIds(ids);
            ((LambdaUpdateChainWrapper)this.mdmCustomerSupplyDetailService.lambdaUpdate().in(MdmCustomerSupplyDetailEntity::getSupplyId, ids)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByCustomer(String customerCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            this.removeByCustomers(Collections.singletonList(customerCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByCustomers(List<String> customerCodes) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerSupplyEntity::getCustomerCode, customerCodes)).select(new SFunction[]{BaseIdEntity::getId}).list()))) {
            this.removeRelations(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPosition(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositions(Collections.singletonList(positionCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositions(List<String> positionCodes) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerSupplyEntity::getPositionCode, positionCodes)).select(new SFunction[]{BaseIdEntity::getId}).list()))) {
            this.removeRelations(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public void setUpDocking(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByCustomerCodeList(Collections.singletonList(customerCode));
        if (CollectionUtil.listEmpty((List)mdmCustomerMsgReqVo.getMdmCustomerDockingVos())) {
            return;
        }
        List mdmCustomerDockingVos = mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mdmCustomerDockingVos)) {
            ArrayList detailReqVos = new ArrayList();
            for (MdmCustomerDockingReqVo mdmCustomerDockingVo : mdmCustomerDockingVos) {
                mdmCustomerDockingVo.setCustomerCode(customerCode);
                String id = UUID.randomUUID().toString();
                mdmCustomerDockingVo.setId(id);
                List mdmCustomerSupplyDetailVos = mdmCustomerDockingVo.getMdmCustomerSupplyDetailVos();
                if (CollectionUtils.isEmpty((Collection)mdmCustomerSupplyDetailVos)) continue;
                for (MdmCustomerSupplyDetailReqVo mdmCustomerSupplyDetailVo : mdmCustomerSupplyDetailVos) {
                    mdmCustomerSupplyDetailVo.setId(null);
                    mdmCustomerSupplyDetailVo.setSupplyId(id);
                }
                detailReqVos.addAll(mdmCustomerSupplyDetailVos);
            }
            if (!CollectionUtils.isEmpty(detailReqVos)) {
                List detailEntities = CrmBeanUtil.copyList(detailReqVos, MdmCustomerSupplyDetailEntity.class);
                this.mdmCustomerSupplyDetailService.saveBatch(detailEntities);
            }
            List mdmPositionCustomerEntities = CrmBeanUtil.copyList(mdmCustomerDockingVos, MdmCustomerSupplyEntity.class);
            this.saveBatch(mdmPositionCustomerEntities);
        }
    }

    @Override
    public void removeByCustomerCodeList(List<String> customerCodeList) {
        this.removeByCustomers(customerCodeList);
    }

    @Override
    public List<MdmCustomerDockingRespVo> findDockingListByCustomerCode(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        List<MdmCustomerDockingRespVo> list = this.mdmCustomerSupplyMapper.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (!CollectionUtils.isEmpty(list)) {
            List supplyIdList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getId())).map(UuidVo::getId).collect(Collectors.toList());
            List detailEntities = ((LambdaQueryChainWrapper)this.mdmCustomerSupplyDetailService.lambdaQuery().in(MdmCustomerSupplyDetailEntity::getSupplyId, supplyIdList)).list();
            if (!CollectionUtils.isEmpty((Collection)detailEntities)) {
                List mdmCustomerSupplyDetailRespVos = CrmBeanUtil.copyList((List)detailEntities, MdmCustomerSupplyDetailRespVo.class);
                Map<String, List<MdmCustomerSupplyDetailRespVo>> detailMap = mdmCustomerSupplyDetailRespVos.stream().collect(Collectors.groupingBy(MdmCustomerSupplyDetailRespVo::getSupplyId));
                for (MdmCustomerDockingRespVo mdmCustomerDockingRespVo : list) {
                    mdmCustomerDockingRespVo.setMdmCustomerSupplyDetailVos(detailMap.get(mdmCustomerDockingRespVo.getId()));
                }
            }
        }
        return list;
    }
}

