/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.notice.mapper.MdmNoticeFileMapper;
import com.biz.crm.notice.model.MdmNoticeFileEntity;
import com.biz.crm.notice.service.IMdmNoticeFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmNoticeFileServiceExpandImpl"})
@Transactional
public class MdmNoticeFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeFileMapper, MdmNoticeFileEntity>
implements IMdmNoticeFileService {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeFileServiceImpl.class);
    @Resource
    private MdmNoticeFileMapper mdmNoticeFileMapper;

    @Override
    @CrmLog
    public PageResult<MdmNoticeFileRespVo> findList(MdmNoticeFileReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmNoticeFileRespVo> list = this.mdmNoticeFileMapper.findList((Page<MdmNoticeFileRespVo>)page, reqVo);
        list.forEach(data -> data.setFilePath(data.getRealPath() + data.getUrlPath()));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public MdmNoticeFileRespVo query(MdmNoticeFileReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new MdmNoticeFileRespVo();
        }
        MdmNoticeFileRespVo mdmNoticeFileRespVo = (MdmNoticeFileRespVo)list.get(0);
        return mdmNoticeFileRespVo;
    }

    @Override
    @CrmLog
    public void save(MdmNoticeFileReqVo reqVo) {
        MdmNoticeFileEntity entity = (MdmNoticeFileEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmNoticeFileEntity.class));
        this.save((Object)entity);
    }

    @Override
    @CrmLog
    public void update(MdmNoticeFileReqVo reqVo) {
        MdmNoticeFileEntity entity = (MdmNoticeFileEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @CrmLog
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeFileEntities = this.mdmNoticeFileMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeFileEntities)) {
            mdmNoticeFileEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }

    @Override
    @CrmLog
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeFileEntities = this.mdmNoticeFileMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeFileEntities)) {
            mdmNoticeFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }

    @Override
    @CrmLog
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeFileEntities = this.mdmNoticeFileMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeFileEntities)) {
            mdmNoticeFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }
}

