/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelCustomerPageRespVo;
import com.biz.crm.org.mapper.MdmOrgCustomerMapper;
import com.biz.crm.org.service.MdmOrgCustomerService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmOrgCustomerServiceImpl
implements MdmOrgCustomerService {
    @Resource
    private MdmOrgCustomerMapper mdmOrgCustomerMapper;
    @Resource
    private MdmCustomerMsgService mdmcustomerMsgService;

    @Override
    public PageResult<MdmOrgRelCustomerPageRespVo> findOrgCustomerList(MdmOrgRelCustomerPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmOrgRelCustomerPageRespVo> list = this.mdmOrgCustomerMapper.findOrgCustomerList((Page<MdmOrgRelCustomerPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgRelCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.hasText((String)reqVo.getOriginOrgCode(), (String)"\u7f3a\u5931\u6e90\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmOrgCustomerUpdateReqVo mdmOrgCustomerReqVo = new MdmOrgCustomerUpdateReqVo();
        mdmOrgCustomerReqVo.setCustomerCodeList(reqVo.getCustomerCodeList());
        mdmOrgCustomerReqVo.setOriginOrgCode(reqVo.getOriginOrgCode());
        mdmOrgCustomerReqVo.setOrgCode(reqVo.getOrgCode());
        this.mdmcustomerMsgService.batchUpdateCustomerOrg(mdmOrgCustomerReqVo);
    }
}

