/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.mapper.MdmUserRelationCustomerMapper;
import com.biz.crm.user.service.MdmUserRelationCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MdmUserRelationCustomerServiceImpl
implements MdmUserRelationCustomerService {
    @Resource
    private MdmUserRelationCustomerMapper mdmUserRelationCustomerMapper;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerNotRelateAnyUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        this.setOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerNotRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        this.setOrgName(list);
        this.setPositionCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerHasRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setId(item.getSupplyId()));
        }
        this.setOrgName(list);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void setOrgName(List<MdmUserRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Map<String, List<MdmOrgRespVo>> map = this.mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmUserRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getCustomerCode())) {
                List orgList = (List)map.get(item.getCustomerCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    private void setPositionCodeName(List<MdmUserRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List positionList;
            List terminalCodeList = list.stream().map(MdmUserRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList());
            List terminalSupplyList = ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getCustomerCode, terminalCodeList)).select(new SFunction[]{MdmCustomerSupplyEntity::getCustomerCode, MdmCustomerSupplyEntity::getPositionCode}).list();
            List positionCodeList = terminalSupplyList.stream().map(MdmCustomerSupplyEntity::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName}).list()))) {
                Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                Map collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.groupingBy(MdmCustomerSupplyEntity::getCustomerCode, Collectors.mapping(MdmCustomerSupplyEntity::getPositionCode, Collectors.toList())));
                list.forEach(item -> {
                    if (collect.containsKey(item.getCustomerCode())) {
                        List positionCodeListInThisCustomer = (List)collect.get(item.getCustomerCode());
                        ArrayList positionListInThisCustomer = new ArrayList();
                        for (String positionCode : positionCodeListInThisCustomer) {
                            if (!positionMap.containsKey(positionCode)) continue;
                            positionListInThisCustomer.add(positionMap.get(positionCode));
                        }
                        item.setPositionCode(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.joining(",")));
                        item.setPositionName(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.joining(",")));
                    }
                });
            }
        }
    }
}

