/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.notice.mapper.MdmNoticeReadMapper;
import com.biz.crm.notice.model.MdmNoticeReadEntity;
import com.biz.crm.notice.service.IMdmNoticeReadService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmNoticeReadServiceExpandImpl"})
@Transactional
public class MdmNoticeReadServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeReadMapper, MdmNoticeReadEntity>
implements IMdmNoticeReadService {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeReadServiceImpl.class);
    @Resource
    private MdmNoticeReadMapper mdmNoticeReadMapper;

    @Override
    @CrmLog
    public PageResult<MdmNoticeReadRespVo> findList(MdmNoticeReadReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmNoticeReadRespVo> list = this.mdmNoticeReadMapper.findList((Page<MdmNoticeReadRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public MdmNoticeReadRespVo query(MdmNoticeReadReqVo reqVo) {
        return null;
    }

    @Override
    public void save(String noticeCode) {
        AssertUtils.isNotEmpty((String)noticeCode, (String)"\u516c\u544a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        String createCode = user.getUsername();
        String createPosCode = user.getPoscode();
        String createOrgCode = user.getOrgcode();
        MdmNoticeReadReqVo req = new MdmNoticeReadReqVo();
        req.setCreateCode(createCode);
        req.setCreatePosCode(createPosCode);
        req.setCreateOrgCode(createOrgCode);
        req.setNoticeCode(noticeCode);
        Integer count = this.mdmNoticeReadMapper.findReadSignCount(req);
        if (count == 0) {
            MdmNoticeReadEntity entity = new MdmNoticeReadEntity();
            entity.setPosCode(createPosCode);
            entity.setUserName(createCode);
            entity.setNoticeCode(noticeCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(MdmNoticeReadReqVo reqVo) {
        MdmNoticeReadEntity entity = (MdmNoticeReadEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @CrmLog
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeReadEntities = this.mdmNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeReadEntities)) {
            mdmNoticeReadEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmNoticeReadEntities);
    }

    @Override
    @CrmLog
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeReadEntities = this.mdmNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeReadEntities)) {
            mdmNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeReadEntities);
    }

    @Override
    @CrmLog
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeReadEntities = this.mdmNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeReadEntities)) {
            mdmNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeReadEntities);
    }
}

