/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.dict.mapper.MdmDictAttrConfMapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmDictAttrConfServiceExpandImpl"})
public class MdmDictAttrConfServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDictAttrConfMapper, MdmDictAttrConfEntity>
implements MdmDictAttrConfService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictAttrConfServiceImpl.class);
    @Resource
    private MdmDictAttrConfMapper mdmDictAttrConfMapper;
    @Resource
    private MdmDictTypeService mdmDictTypeService;
    @Resource
    private MdmDictDataService mdmDictDataService;

    @Override
    public List<MdmDictAttrConfRespVo> findList(String dictTypeCode) {
        Assert.hasText((String)dictTypeCode, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmDictAttrConfRespVo.class);
        }
        return new ArrayList<MdmDictAttrConfRespVo>();
    }

    @Override
    public MdmDictAttrConfRespVo detail(String id) {
        MdmDictAttrConfEntity one;
        if (StringUtils.isNotEmpty((String)id) && (one = (MdmDictAttrConfEntity)((Object)this.getById((Serializable)((Object)id)))) != null) {
            return (MdmDictAttrConfRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDictAttrConfRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDictAttrConfReqVo reqVo) {
        reqVo.setId(null);
        this.verify(reqVo);
        String extField = "";
        List<String> defaultExtFieldList = Arrays.asList("ext1", "ext2", "ext3", "ext4", "ext5", "ext6", "ext7", "ext8", "ext9", "ext10");
        HashSet extFieldList = new HashSet(16);
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            extFieldList.addAll(list.stream().map(MdmDictAttrConfEntity::getExtField).collect(Collectors.toSet()));
        }
        for (String item : defaultExtFieldList) {
            if (extFieldList.contains(item)) continue;
            extField = item;
            break;
        }
        Assert.hasText((String)extField, (String)"\u6269\u5c55\u5b57\u6bb5\u5df2\u7ecf\u7528\u5c3d\uff0c\u6bcf\u4e2a\u5b57\u5178\u6700\u591a\u6dfb\u52a010\u4e2a\u6269\u5c55\u5b57\u6bb5");
        MdmDictAttrConfEntity entity = (MdmDictAttrConfEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDictAttrConfEntity.class));
        entity.setExtField(extField);
        this.mdmDictDataService.deleteExtFieldVal(entity.getDictTypeCode(), Collections.singletonList(extField));
        this.save((Object)entity);
        DictUtil.deleteRedisCache((String)entity.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDictAttrConfReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictAttrConfEntity entity = (MdmDictAttrConfEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
        this.verify(reqVo);
        Assert.hasText((String)reqVo.getExtField(), (String)"\u5360\u7528\u6570\u636e\u8868\u7684\u6269\u5c55\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)entity.getExtField().equals(reqVo.getExtField()), (String)"\u5360\u7528\u6570\u636e\u8868\u7684\u6269\u5c55\u5b57\u6bb5\u4e0d\u80fd\u4fee\u6539");
        if (reqVo.getSelectDictTypeCode() != null && !reqVo.getSelectDictTypeCode().equals(entity.getSelectDictTypeCode()) || entity.getSelectDictTypeCode() != null && !entity.getSelectDictTypeCode().equals(reqVo.getSelectDictTypeCode())) {
            this.mdmDictDataService.deleteExtFieldVal(entity.getDictTypeCode(), Collections.singletonList(entity.getExtField()));
        }
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        DictUtil.deleteRedisCache((String)entity.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Map<String, List<MdmDictAttrConfEntity>> map = list.stream().collect(Collectors.groupingBy(MdmDictAttrConfEntity::getDictTypeCode));
        for (Map.Entry<String, List<MdmDictAttrConfEntity>> entry : map.entrySet()) {
            List<String> extFieldList = entry.getValue().stream().map(MdmDictAttrConfEntity::getExtField).collect(Collectors.toList());
            this.mdmDictDataService.deleteExtFieldVal(entry.getKey(), extFieldList);
            DictUtil.deleteRedisCache((String)entry.getKey());
        }
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDictTypeCode(String dictTypeCode) {
        Assert.hasText((String)dictTypeCode, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode)).remove();
    }

    private void verify(MdmDictAttrConfReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178");
        Assert.hasText((String)reqVo.getFieldCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFieldName(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqVo.getShowOrder(), (String)"\u663e\u793a\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqVo.getRequired(), (String)"\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getSelectDictTypeCode())) {
            MdmDictTypeEntity selectDict = (MdmDictTypeEntity)((Object)((LambdaQueryChainWrapper)this.mdmDictTypeService.lambdaQuery().eq(MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getSelectDictTypeCode())).one());
            Assert.notNull((Object)((Object)selectDict), (String)"\u4e0b\u62c9\u6846\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u65e0\u6548");
        }
        MdmDictTypeEntity one = (MdmDictTypeEntity)((Object)((LambdaQueryChainWrapper)this.mdmDictTypeService.lambdaQuery().eq(MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5173\u8054\u6570\u636e\u5b57\u5178\u7c7b\u578b");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List fieldList = list.stream().map(MdmDictAttrConfEntity::getFieldCode).collect(Collectors.toList());
            Assert.isTrue((!fieldList.contains(reqVo.getFieldCode()) ? 1 : 0) != 0, (String)("\u5f53\u524d\u6570\u636e\u5b57\u5178\u4e0b\u5df2\u7ecf\u5b58\u5728\u8be5\u5b57\u6bb5\uff1a" + reqVo.getFieldCode()));
        }
    }
}

