/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.MdmUserRelWeChatOriginModuleEnum;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.login.MdmAppletWeChatBindLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.service.RedisService;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmSystemLoginServiceExpandImpl"})
public class MdmSystemLoginServiceImpl
implements MdmSystemLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSystemLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private MdmOrgService orgService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Value(value="${user_lock_config:false}")
    private Boolean userLockConfig;

    @Override
    public MdmLoginRespVo systemLogin(MdmLoginReqVo mdmLoginReqVo) {
        MdmUserRespVo mdmUserRespVo = this.validUser(mdmLoginReqVo);
        MdmPositionRespVo mdmPositionRespVo = this.validPosition(mdmUserRespVo);
        MdmOrgRespVo mdmOrgRespVo = this.validOrg(mdmPositionRespVo);
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        this.storeRedis(mdmUserRespVo, mdmPositionRespVo, mdmOrgRespVo, token);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(mdmUserRespVo.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        mdmLoginRespVo.setPositionCode(mdmPositionRespVo.getPositionCode());
        mdmLoginRespVo.setPositionName(mdmPositionRespVo.getPositionName());
        mdmLoginRespVo.setOrgCode(mdmOrgRespVo.getOrgCode());
        mdmLoginRespVo.setOrgName(mdmOrgRespVo.getOrgName());
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        return mdmLoginRespVo;
    }

    @Override
    public MdmLoginRespVo sfaAppletWxLogin(String openId) {
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        MdmUserRelWeChatEntity one = (MdmUserRelWeChatEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmUserRelWeChatService.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)MdmUserRelWeChatOriginModuleEnum.APPLET_SFA.getValue())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).one());
        Assert.notNull((Object)((Object)one), (String)"\u672a\u7ed1\u5b9a\u7528\u6237");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(one.getUserName());
        mdmUserReqVo.setUserType(UserTypeEnum.USER.getCode());
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        this.validLock(mdmUserRespVo.getUserName());
        this.clearLock(mdmUserRespVo.getUserName());
        MdmPositionRespVo mdmPositionRespVo = this.validPosition(mdmUserRespVo);
        MdmOrgRespVo mdmOrgRespVo = this.validOrg(mdmPositionRespVo);
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        this.storeRedis(mdmUserRespVo, mdmPositionRespVo, mdmOrgRespVo, token);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(mdmUserRespVo.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        mdmLoginRespVo.setPositionCode(mdmPositionRespVo.getPositionCode());
        mdmLoginRespVo.setPositionName(mdmPositionRespVo.getPositionName());
        mdmLoginRespVo.setOrgCode(mdmOrgRespVo.getOrgCode());
        mdmLoginRespVo.setOrgName(mdmOrgRespVo.getOrgName());
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        return mdmLoginRespVo;
    }

    @Override
    public MdmLoginRespVo sfaAppletBindWxLogin(MdmAppletWeChatBindLoginReqVo reqVo) {
        MdmLoginReqVo validUserReq = new MdmLoginReqVo();
        validUserReq.setUserName(reqVo.getUserName());
        validUserReq.setPassword(reqVo.getPassword());
        this.validUser(validUserReq);
        MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)bindReq);
        bindReq.setOriginModule(MdmUserRelWeChatOriginModuleEnum.APPLET_SFA.getValue());
        this.mdmUserRelWeChatService.bind(bindReq);
        return this.sfaAppletWxLogin(reqVo.getOpenId());
    }

    @Override
    public void systemLogout() {
        UserUtils.remove();
    }

    protected void storeRedis(MdmUserRespVo mdmUserRespVo, MdmPositionRespVo mdmPositionRespVo, MdmOrgRespVo mdmOrgRespVo, String token) {
        UserRedis userRedis = new UserRedis();
        userRedis.setOrgcode(mdmOrgRespVo.getOrgCode());
        userRedis.setOrgname(mdmOrgRespVo.getOrgName());
        userRedis.setPoscode(mdmPositionRespVo.getPositionCode());
        userRedis.setPosname(mdmPositionRespVo.getPositionName());
        userRedis.setUsername(mdmUserRespVo.getUserName());
        userRedis.setRealname(mdmUserRespVo.getFullName());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
    }

    protected MdmOrgRespVo validOrg(MdmPositionRespVo mdmPositionRespVo) {
        MdmOrgRespVo mdmOrgRespVo = this.orgService.detail(null, mdmPositionRespVo.getOrgCode());
        Assert.notNull((Object)mdmOrgRespVo, (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7ec4\u7ec7\u4fe1\u606f:{}", (Object)mdmOrgRespVo);
        return mdmOrgRespVo;
    }

    protected MdmPositionRespVo validPosition(MdmUserRespVo mdmUserRespVo) {
        MdmPositionRespVo mdmPositionRespVo = this.mdmPositionService.getUserCurrentPositionForLogin(mdmUserRespVo.getUserName());
        Assert.notNull((Object)mdmPositionRespVo, (String)"\u4e3b\u804c\u4f4d\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u4e3b\u804c\u4f4d:{}", (Object)mdmPositionRespVo);
        Assert.hasText((String)mdmPositionRespVo.getOrgCode(), (String)"\u804c\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        return mdmPositionRespVo;
    }

    protected MdmUserRespVo validUser(MdmLoginReqVo mdmLoginReqVo) {
        String userName = mdmLoginReqVo.getUserName();
        String password = mdmLoginReqVo.getPassword();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userName);
        mdmUserReqVo.setUserType(UserTypeEnum.USER.getCode());
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        this.validLock(mdmUserRespVo.getUserName());
        String pwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        if (StringUtils.isEmpty((Object)pwd) || !pwd.equals(mdmUserRespVo.getUserPassword())) {
            this.updateLock(mdmUserReqVo.getUserName());
        } else {
            this.clearLock(mdmUserRespVo.getUserName());
        }
        String enableStatus = mdmUserRespVo.getEnableStatus();
        Assert.isTrue((!StringUtils.isEmpty((Object)enableStatus) && CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? 1 : 0) != 0, (String)"\u7528\u6237\u6ca1\u6709\u542f\u7528");
        String startTime = mdmUserRespVo.getStartTime();
        String endTime = mdmUserRespVo.getEndTime();
        if (!StringUtils.isEmpty((Object)startTime) && !StringUtils.isEmpty((Object)endTime)) {
            String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            Assert.isTrue((format.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
            Assert.isTrue((format.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
        return mdmUserRespVo;
    }

    @Override
    public void unLockUser(List<String> usernameList) {
        if (CollectionUtils.isEmpty(usernameList)) {
            return;
        }
        for (String username : usernameList) {
            this.redisService.del(new String[]{"login_lock_time:" + username});
        }
    }

    @Override
    public void validLock(String username) {
        if (this.userLockConfig.booleanValue()) {
            String loginErrorFrequency = ParamUtil.getParameterValue((String)"login_error_frequency");
            String loginLockTime = ParamUtil.getParameterValue((String)"login_lock_time");
            if (!StringUtils.isEmpty((Object)loginErrorFrequency) && !StringUtils.isEmpty((Object)loginLockTime)) {
                Object o = this.redisService.get("login_lock_time:" + username);
                if (o != null) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmUserService.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)username)).eq(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
                    throw new BusinessException("\u7528\u6237\u5df2\u88ab\u9501\u5b9a" + loginLockTime + "\u5206\u949f");
                }
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmUserService.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)username)).eq(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            }
        }
    }

    @Override
    public void clearLock(String username) {
        if (this.userLockConfig.booleanValue()) {
            String loginErrorFrequency = ParamUtil.getParameterValue((String)"login_error_frequency");
            String loginLockTime = ParamUtil.getParameterValue((String)"login_lock_time");
            if (!StringUtils.isEmpty((Object)loginErrorFrequency) && !StringUtils.isEmpty((Object)loginLockTime)) {
                this.redisService.del(new String[]{"login_error_frequency:" + username});
                this.redisService.del(new String[]{"login_lock_time:" + username});
            }
        }
    }

    @Override
    public void updateLock(String username) {
        if (this.userLockConfig.booleanValue()) {
            String loginErrorFrequency = ParamUtil.getParameterValue((String)"login_error_frequency");
            String loginLockTime = ParamUtil.getParameterValue((String)"login_lock_time");
            if (!StringUtils.isEmpty((Object)loginErrorFrequency) && !StringUtils.isEmpty((Object)loginLockTime)) {
                Integer currentErrorFrequency = (Integer)this.redisService.get("login_error_frequency:" + username);
                if (currentErrorFrequency != null) {
                    int frequency = Integer.parseInt(loginErrorFrequency);
                    if (currentErrorFrequency >= frequency) {
                        this.redisService.del(new String[]{"login_error_frequency:" + username});
                        this.redisService.setMinutes("login_lock_time:" + username, (Object)1, (long)Integer.parseInt(loginLockTime));
                        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmUserService.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)username)).eq(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(MdmUserEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
                        throw new BusinessException("\u7528\u6237\u5df2\u88ab\u9501\u5b9a" + loginLockTime + "\u5206\u949f");
                    }
                }
                this.redisService.incr("login_error_frequency:" + username, 1L);
                if (currentErrorFrequency == null) {
                    throw new BusinessException("\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u60a8\u8fd8\u6709" + loginErrorFrequency + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
                }
                Integer loginErrorFrequencyNum = Integer.valueOf(loginErrorFrequency);
                throw new BusinessException("\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u60a8\u8fd8\u6709" + (loginErrorFrequencyNum - currentErrorFrequency) + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
            }
        }
        throw new BusinessException("\u5bc6\u7801\u4e0d\u6b63\u786e");
    }
}

