/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.notice.mapper.MdmNoticeCommentMapper;
import com.biz.crm.notice.mapper.MdmNoticeMapper;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import com.biz.crm.notice.model.MdmNoticeEntity;
import com.biz.crm.notice.service.IMdmNoticeCommentService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmNoticeCommentServiceImpl"})
@Transactional
public class MdmNoticeCommentServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeCommentMapper, MdmNoticeCommentEntity>
implements IMdmNoticeCommentService {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeCommentServiceImpl.class);
    @Resource
    private MdmNoticeCommentMapper mdmNoticeCommentMapper;
    @Resource
    private MdmNoticeMapper mdmNoticeMapper;

    @Override
    public List<MdmNoticeCommentRespVo> findCommentList(String noticeId) {
        return this.mdmNoticeCommentMapper.findCommentList(noticeId);
    }

    @Override
    public void save(String id, String commentText) {
        AssertUtils.isNotEmpty((String)id, (String)"\u516c\u544aid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeEntity mdmNotice = (MdmNoticeEntity)((Object)this.mdmNoticeMapper.selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)mdmNotice), (String)"\u8be5\u516c\u544a\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        UserRedis user = UserUtils.getUser();
        MdmNoticeCommentReqVo mdmNoticeCommentReqVo = new MdmNoticeCommentReqVo();
        String commentTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        mdmNoticeCommentReqVo.setNoticeId(id).setCommentName(user.getUsername()).setCommentOrgName(user.getOrgname()).setCommentPosName(user.getPosname()).setCommentText(commentText).setCommentTime(commentTime).setCommentNumLikes("0").setVisibleState("1");
        MdmNoticeCommentEntity noticeCommentEntity = (MdmNoticeCommentEntity)((Object)CrmBeanUtil.copy((Object)mdmNoticeCommentReqVo, MdmNoticeCommentEntity.class));
        this.save((Object)noticeCommentEntity);
    }

    @Override
    public void updateNoticeVisible(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u8bc4\u8bbaid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeCommentEntity mdmNoticeCommentEntity = (MdmNoticeCommentEntity)((Object)this.mdmNoticeCommentMapper.selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)mdmNoticeCommentEntity), (String)"\u8be5\u8bc4\u8bba\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        String visibleState = mdmNoticeCommentEntity.getVisibleState();
        if ("0".equals(visibleState)) {
            mdmNoticeCommentEntity.setVisibleState("1");
        } else {
            mdmNoticeCommentEntity.setVisibleState("0");
        }
        this.mdmNoticeCommentMapper.updateById((Object)mdmNoticeCommentEntity);
    }
}

