/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.button.model.MdmButtonRoleEntity;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmButtonConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.nebular.mdm.role.req.MdmSwitchFunctionButtonReqVo;
import com.biz.crm.tableconfig.mapper.MdmFunctionSubButtonMapper;
import com.biz.crm.tableconfig.mapper.MdmFunctionSubMapper;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionSubButtonServiceExpandImpl"})
public class MdmFunctionSubButtonServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionSubButtonMapper, MdmFunctionSubButtonEntity>
implements IMdmFunctionSubButtonService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionSubButtonServiceImpl.class);
    @Autowired
    private MdmButtonService mdmButtonService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private MdmFunctionSubMapper mdmFunctionSubMapper;
    @Autowired
    private MdmButtonRoleService mdmButtonRoleService;
    @Autowired
    private MdmFunctionService mdmFunctionService;

    @Override
    public void setUp(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        this.valid(mdmFunctionSubButtonReqVo);
        mdmFunctionSubButtonReqVo.setId(null);
        this.save(CrmBeanUtil.copy((Object)mdmFunctionSubButtonReqVo, MdmFunctionSubButtonEntity.class));
    }

    @Override
    public List<MdmButtonConfigRespVo> buttonList(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        return this.mdmFunctionSubMapper.buttonList(mdmFunctionSubButtonReqVo);
    }

    @Override
    public void buttonRemove(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity = (MdmFunctionSubButtonEntity)((Object)list.get(0));
            String parentCode = mdmFunctionSubButtonEntity.getParentCode();
            String functionCode = mdmFunctionSubButtonEntity.getFunctionCode();
            if (!StringUtils.isEmpty((Object)parentCode) && !StringUtils.isEmpty((Object)functionCode)) {
                TableConfigUtil.removeListConfig((String)parentCode, (String)functionCode);
            }
            this.removeByIds(ids);
        }
    }

    @Override
    public MdmButtonConfigRespVo buttonQuery(String id) {
        return this.mdmFunctionSubMapper.buttonQuery(id);
    }

    @Override
    public List<MdmRoleSubButtonVo> buttonList(MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo) {
        String parentCode = mdmRoleSubButtonReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = mdmRoleSubButtonReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = mdmRoleSubButtonReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmRoleSubButtonVo> buttonList = this.mdmFunctionSubMapper.buttonSelectList(mdmRoleSubButtonReqVo);
        if (CollectionUtils.isEmpty(buttonList)) {
            return buttonList;
        }
        List<String> buttonCodeList = this.mdmButtonRoleService.findButtonCodeByRole(roleCode, parentCode, functionCode);
        if (!CollectionUtils.isEmpty(buttonCodeList)) {
            for (MdmRoleSubButtonVo mdmRoleSubButtonVo : buttonList) {
                String buttonCode = mdmRoleSubButtonVo.getButtonCode();
                if (StringUtils.isEmpty((Object)buttonCode) || !buttonCodeList.contains(buttonCode)) continue;
                mdmRoleSubButtonVo.setButtonSelect(YesNoEnum.yesNoEnum.ONE.getValue());
            }
        }
        return buttonList;
    }

    @Override
    public void switchFunctionButton(MdmSwitchFunctionButtonReqVo mdmSwitchFunctionButtonReqVo) {
        String functionCode = mdmSwitchFunctionButtonReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = mdmSwitchFunctionButtonReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String status = mdmSwitchFunctionButtonReqVo.getStatus();
        Assert.hasText((String)status, (String)"\u52fe\u9009\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> functionCodeList = this.mdmFunctionService.findCurrentAndSubFunctionCodeList(functionCode);
        if (CollectionUtils.isEmpty(functionCodeList)) {
            return;
        }
        if (YesNoEnum.yesNoEnum.ZERO.getValue().equals(status)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmButtonRoleService.lambdaUpdate().eq(MdmButtonRoleEntity::getRoleCode, (Object)roleCode)).in(MdmButtonRoleEntity::getParentCode, functionCodeList)).remove();
            return;
        }
        List mdmFunctionSubButtonEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmFunctionSubButtonEntity::getParentCode, functionCodeList)).select(new SFunction[]{MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode}).list();
        if (CollectionUtils.isEmpty((Collection)mdmFunctionSubButtonEntities)) {
            return;
        }
        List mdmRoleSubButtonVos = CrmBeanUtil.copyList((List)mdmFunctionSubButtonEntities, MdmRoleSubButtonVo.class);
        for (MdmRoleSubButtonVo mdmRoleSubButtonVo : mdmRoleSubButtonVos) {
            mdmRoleSubButtonVo.setButtonSelect(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        this.mdmButtonRoleService.setUp(roleCode, mdmRoleSubButtonVos);
    }

    protected void valid(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        String parentCode = mdmFunctionSubButtonReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = mdmFunctionSubButtonReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String buttonCode = mdmFunctionSubButtonReqVo.getButtonCode();
        Assert.hasText((String)buttonCode, (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmButtonRespVo mdmButtonRespVo = this.mdmButtonService.query(null, buttonCode);
        Assert.notNull((Object)mdmButtonRespVo, (String)"\u6309\u94ae\u4e0d\u5b58\u5728");
        String enableStatus = mdmButtonRespVo.getEnableStatus();
        Assert.isTrue((!StringUtils.isEmpty((Object)enableStatus) && CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? 1 : 0) != 0, (String)"\u6309\u94ae\u4e0d\u662f\u542f\u7528\u72b6\u6001");
        Integer functionCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).count();
        Assert.isTrue((functionCount != null && functionCount > 0 ? 1 : 0) != 0, (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmFunctionSubButtonEntity::getParentCode, (Object)mdmFunctionSubButtonReqVo.getParentCode())).eq(MdmFunctionSubButtonEntity::getFunctionCode, (Object)mdmFunctionSubButtonReqVo.getFunctionCode())).eq(MdmFunctionSubButtonEntity::getButtonCode, (Object)mdmFunctionSubButtonReqVo.getButtonCode())).remove();
        TableConfigUtil.removeListConfig((String)parentCode, (String)functionCode);
    }
}

