/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmDirectSystemService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDirectSystemServiceExpandImpl"})
public class MdmDirectSystemServiceImpl
implements MdmDirectSystemService {
    private static final Logger log = LoggerFactory.getLogger(MdmDirectSystemServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public List<MdmDirectSystemVo> directSystemSelect(MdmDirectSystemVo mdmDirectSystemVo) {
        ParameterizedTypeReference<KmsResultVo<List<KmsDirectSystemVo>>> reference;
        if (!this.valid()) {
            return Collections.emptyList();
        }
        String url = this.kmsProperties.getUrl() + "/directSystemController/findDirectSystemListWithNum";
        ResponseEntity exchange = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)this.kmsProperties, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<List<KmsDirectSystemVo>>>(){}));
        List kmsDirectSystemVos = Optional.ofNullable(exchange).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsDirectSystemVos)) {
            return Collections.emptyList();
        }
        String directSystemName = mdmDirectSystemVo.getDirectSystemName();
        String enableStatus = mdmDirectSystemVo.getEnableStatus();
        List<Object> mdmDirectSystemVos = KmsConverter.INSTANCE.directSystem2Mdm(kmsDirectSystemVos);
        mdmDirectSystemVos = mdmDirectSystemVos.stream().filter(x -> StringUtils.isEmpty((Object)directSystemName) || x.getDirectSystemName().contains(directSystemName)).filter(x -> StringUtils.isEmpty((Object)enableStatus) || enableStatus.equals(x.getEnableStatus())).collect(Collectors.toList());
        return mdmDirectSystemVos;
    }

    protected boolean valid() {
        return !StringUtils.isEmpty((Object)this.kmsProperties.getAccessToken());
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.kmsProperties.getUrl() + "/directSystemController/stopOrUse?access_token=" + this.kmsProperties.getAccessToken();
        for (String id : ids) {
            KmsDirectSystemVo kmsDirectSystemVo = new KmsDirectSystemVo();
            kmsDirectSystemVo.setDirectSystemId(id);
            kmsDirectSystemVo.setComomStatus("ENABLE");
            kmsDirectSystemVo.setTenantryId(this.kmsProperties.getTenantryId());
            kmsDirectSystemVo.setUserId(this.kmsProperties.getUserId());
            ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsDirectSystemVo, String.class);
            if (HttpStatus.OK.equals((Object)entity.getStatusCode())) continue;
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.kmsProperties.getUrl() + "/directSystemController/stopOrUse?access_token=" + this.kmsProperties.getAccessToken();
        for (String id : ids) {
            KmsDirectSystemVo kmsDirectSystemVo = new KmsDirectSystemVo();
            kmsDirectSystemVo.setDirectSystemId(id);
            kmsDirectSystemVo.setComomStatus("DISABLE");
            kmsDirectSystemVo.setTenantryId(this.kmsProperties.getTenantryId());
            kmsDirectSystemVo.setUserId(this.kmsProperties.getUserId());
            ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsDirectSystemVo, String.class);
            if (HttpStatus.OK.equals((Object)entity.getStatusCode())) continue;
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    @Override
    public List<MdmDirectSystemVo> unAddSelect(MdmDirectSystemVo mdmDirectSystemVo) {
        ParameterizedTypeReference<KmsResultVo<List<KmsDirectSystemVo>>> reference;
        String url = this.kmsProperties.getUrl() + "/directSystemController/findDirectSystemSelect";
        ResponseEntity exchange = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)this.kmsProperties, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<List<KmsDirectSystemVo>>>(){}));
        List kmsDirectSystemVos = Optional.ofNullable(exchange).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsDirectSystemVos)) {
            return Collections.emptyList();
        }
        String directSystemName = mdmDirectSystemVo.getDirectSystemName();
        String enableStatus = mdmDirectSystemVo.getEnableStatus();
        List<Object> mdmDirectSystemVos = KmsConverter.INSTANCE.directSystem2Mdm(kmsDirectSystemVos);
        mdmDirectSystemVos = mdmDirectSystemVos.stream().filter(x -> StringUtils.isEmpty((Object)directSystemName) || x.getDirectSystemName().contains(directSystemName)).filter(x -> StringUtils.isEmpty((Object)enableStatus) || enableStatus.equals(x.getEnableStatus())).collect(Collectors.toList());
        return mdmDirectSystemVos;
    }

    @Override
    public void add(MdmDirectSystemVo mdmDirectSystemVo) {
        Assert.hasText((String)mdmDirectSystemVo.getBsDirectId(), (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmDirectSystemVo.getDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmDirectSystemVo.getDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmDirectSystemVo> mdmDirectSystemVos = this.directSystemSelect(mdmDirectSystemVo);
        if (!CollectionUtils.isEmpty(mdmDirectSystemVos)) {
            for (MdmDirectSystemVo directSystemVo : mdmDirectSystemVos) {
                if (!mdmDirectSystemVo.getDirectSystemCode().equals(directSystemVo.getDirectSystemCode())) continue;
                throw new BusinessException("\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        KmsDirectSystemVo kmsDirectSystemVo = new KmsDirectSystemVo();
        kmsDirectSystemVo.setBsDirectId(mdmDirectSystemVo.getBsDirectId());
        kmsDirectSystemVo.setDirectSystemCode(mdmDirectSystemVo.getDirectSystemCode());
        kmsDirectSystemVo.setDirectSystemName(mdmDirectSystemVo.getDirectSystemName());
        kmsDirectSystemVo.setUsername(this.kmsProperties.getUsername());
        kmsDirectSystemVo.setUserId(this.kmsProperties.getUserId());
        kmsDirectSystemVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/directSystemController/saveDirectSystem?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsDirectSystemVo, String.class);
        log.info("[\u76f4\u8425\u4f53\u7cfb][\u65b0\u589e]result:{}", (Object)entity);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }
}

