/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ResourceReader {
    private static final String subMoudlePropertiesFile = "GeoLite2-City.mmdb";
    private static final String innerPropertiesFile = "own.properties";

    public static void main(String[] args) throws InterruptedException {
        ResourceReader.loadJarFileByConfiguration();
        Thread.sleep(1000L);
        ResourceReader.loadLocalFile();
        Thread.sleep(1000L);
        ResourceReader.loadJarFileByResource();
        Thread.sleep(1000L);
        ResourceReader.loadJarFileByFile();
    }

    private static void loadJarFileByFile() {
        System.out.println("----------loadJarFileByFile---- begin------------");
        URL resource = ResourceReader.class.getClassLoader().getResource(subMoudlePropertiesFile);
        String path = resource.toString();
        System.out.println(path);
        try {
            File file = new File(path);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fileInputStream));
            String s = "";
            while ((s = br.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("----------loadJarFileByFile---- end------------\n\n");
    }

    private static void loadJarFileByConfiguration() {
        System.out.println("----------loadJarFileByConfiguration---- begin------------");
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(subMoudlePropertiesFile);
            Iterator keys = configuration.getKeys();
            while (keys.hasNext()) {
                String next = (String)keys.next();
                System.out.println("key:" + next + "\tvalue:" + configuration.getString(next));
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        System.out.println("----------loadJarFileByConfiguration---- end------------\n\n");
    }

    private static void loadJarFileByResource() {
        System.out.println("----------loadJarFileByResource---- begin------------");
        URL resource = ResourceReader.class.getClassLoader().getResource(subMoudlePropertiesFile);
        String path = resource.toString();
        System.out.println(path);
        try {
            InputStream is = resource.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String s = "";
            while ((s = br.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("----------loadJarFileByResource---- end------------\n\n");
    }

    private static void loadLocalFile() {
        System.out.println("----------loadLocalFile---- begin------------");
        String path = ResourceReader.class.getClassLoader().getResource(innerPropertiesFile).getPath();
        System.out.println(path);
        try {
            String strLine;
            FileReader fileReader = new FileReader(path);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((strLine = bufferedReader.readLine()) != null) {
                System.out.println("strLine:" + strLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("----------loadLocalFile---- begin------------\n\n");
    }
}

