/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.jdbc.SQL;

public class MdmPriceConditionProvider {
    public String findListGroup(Map<String, Object> map) {
        final MdmPriceConditionGroupReqVo vo = (MdmPriceConditionGroupReqVo)map.get("vo");
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*");
                this.FROM("mdm_price_condition_group a");
                if (StringUtils.isNotEmpty((String)vo.getConditionGroupCode())) {
                    this.WHERE("a.condition_group_code like " + ProviderUtil.bindPercent(vo.getConditionGroupCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionGroupDesc())) {
                    this.WHERE("a.condition_group_desc like " + ProviderUtil.bindPercent(vo.getConditionGroupDesc(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }

    public String findListType(Map<String, Object> map) {
        final MdmPriceConditionTypeReqVo vo = (MdmPriceConditionTypeReqVo)map.get("vo");
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*");
                this.FROM("mdm_price_condition_type a");
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeCode())) {
                    this.WHERE("a.condition_type_code like " + ProviderUtil.bindPercent(vo.getConditionTypeCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeDesc())) {
                    this.WHERE("a.condition_type_desc like " + ProviderUtil.bindPercent(vo.getConditionTypeDesc(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeType())) {
                    this.WHERE("a.condition_type_type = #{vo.conditionTypeType}");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }

    public String findListSetting(Map<String, Object> map) {
        final MdmPriceSettingReqVo vo = (MdmPriceSettingReqVo)map.get("vo");
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*,b.condition_type_desc conditionTypeDesc,mpcg.condition_group_desc conditionGroupDesc");
                this.FROM("mdm_price_setting a");
                this.LEFT_OUTER_JOIN("mdm_price_condition_type b on a.condition_type_code = b.condition_type_code");
                this.LEFT_OUTER_JOIN("mdm_price_condition_group mpcg on a.condition_group_code = mpcg.condition_group_code");
                if (StringUtils.isNotEmpty((String)vo.getPriceSettingCode())) {
                    this.WHERE("a.price_setting_code like " + ProviderUtil.bindPercent(vo.getPriceSettingCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeCode())) {
                    this.WHERE("a.condition_type_code like " + ProviderUtil.bindPercent(vo.getConditionTypeCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeDesc())) {
                    this.WHERE("b.condition_type_desc like " + ProviderUtil.bindPercent(vo.getConditionTypeDesc(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getOrgCode())) {
                    this.WHERE("a.org_code like " + ProviderUtil.bindPercent(vo.getOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getOrgName())) {
                    this.WHERE("a.org_name like " + ProviderUtil.bindPercent(vo.getOrgName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getCustomerCode())) {
                    this.WHERE("a.customer_code like " + ProviderUtil.bindPercent(vo.getCustomerCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getCustomerName())) {
                    this.WHERE("a.customer_name like " + ProviderUtil.bindPercent(vo.getCustomerName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getChannel())) {
                    this.WHERE("a.channel = #{vo.channel}");
                }
                if (StringUtils.isNotEmpty((String)vo.getProductCode())) {
                    this.WHERE("a.product_code like " + ProviderUtil.bindPercent(vo.getProductCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getProductName())) {
                    this.WHERE("a.product_name like " + ProviderUtil.bindPercent(vo.getProductName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (!Objects.isNull(vo.getPrice())) {
                    this.WHERE("a.price = #{vo.price}");
                }
                if (StringUtils.isNotEmpty((String)vo.getCurrencyType())) {
                    this.WHERE("a.currency_type = #{vo.currencyType}");
                }
                if (StringUtils.isNotEmpty((String)vo.getBeginDate())) {
                    this.WHERE("a.begin_date &gt;= #{vo.beginDate}");
                }
                if (StringUtils.isNotEmpty((String)vo.getEndDate())) {
                    this.WHERE("a.end_date &lt;= #{vo.endDate}");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }
}

