/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.CustomerOrgChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.TerminalOrgChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.doo.AvailableDo;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleGoodsMapper;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleAreaService;
import com.biz.crm.availablelistrule.service.AvailableListRuleGoodsService;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.AvailableListRuleEunm;
import com.biz.crm.eunm.mdm.AvailableListRuleEnum;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"availableListRuleServiceExpandImpl"})
@Service(value="availableListRuleService")
public class AvailableListRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<AvailableListRuleMapper, AvailableListRuleEntity>
implements AvailableListRuleService {
    @Resource
    private AvailableListRuleMapper availableListRuleMapper;
    @Resource
    private AvailableListRuleGoodsService availableListRuleGoodsService;
    @Resource
    private AvailableListRuleAreaService availableListRuleAreaService;
    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;
    @Resource
    private CustomerOrgChangeAdviseTargetStrategy customerOrgChangeAdviseTargetStrategy;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Resource
    private TerminalOrgChangeAdviseTargetStrategy terminalOrgChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Autowired
    private MdmProductService mdmProductService;
    @Autowired
    private AvailableListRuleGoodsMapper availableListRuleGoodsMapper;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public void add(final AvailableListRuleVo availableListRuleVo) {
        com.biz.crm.customer.utils.ValidateUtils.validate(StringUtils.isEmpty((Object)availableListRuleVo.getCode()), "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        com.biz.crm.customer.utils.ValidateUtils.validate(StringUtils.isEmpty((Object)availableListRuleVo.getName()), "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        com.biz.crm.customer.utils.ValidateUtils.validate(null != availableListRuleVo.getType(), "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        com.biz.crm.customer.utils.ValidateUtils.validate(null != availableListRuleVo.getDimension(), "\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
        List entities = this.availableListRuleMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", availableListRuleVo.getCode());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("code\u91cd\u590d!");
        }
        availableListRuleVo.setSource(StringUtils.isEmpty((Object)availableListRuleVo.getSource()) ? AvailableListRuleEnum.SourceEunm.NOMAL.getCode() : availableListRuleVo.getSource());
        AvailableListRuleEntity entity = new AvailableListRuleEntity();
        BeanUtils.copyProperties((Object)availableListRuleVo, (Object)entity);
        entity.setRuleCode(CodeUtil.createCode());
        this.availableListRuleMapper.insert(entity);
        Integer dimension = entity.getDimension();
        this.availableListRuleGoodsService.replace(availableListRuleVo.getGoods(), entity);
        this.availableListRuleAreaService.replace(availableListRuleVo.getAreaes(), entity);
        AvailableListRuleVo logVo = this.findById(entity.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), logVo.getId(), logVo.getId(), (Object)logVo);
        List<String> codes = null;
        if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getCusCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getTerminalCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        }
        this.advise(codes, AvailableListRuleEunm.Dimension.getByCode((Integer)dimension));
    }

    @Override
    @Transactional
    public void addForConstract(AvailableListRuleVo availableListRuleVo) {
        availableListRuleVo.setCode(CodeUtil.createCode());
        availableListRuleVo.setName("\u5408\u540c\u5b9a\u5236\u89c4\u5219");
        availableListRuleVo.setSource(AvailableListRuleEnum.SourceEunm.CONSTRACT.getCode());
        this.add(availableListRuleVo);
    }

    @Override
    @Transactional
    public void edit(AvailableListRuleVo availableListRuleVo) {
        com.biz.crm.customer.utils.ValidateUtils.validate(StringUtils.isEmpty((Object)availableListRuleVo.getId()), "\u8bf7\u6307\u5b9a\u7f16\u8f91\u7684\u89c4\u5219!");
        com.biz.crm.customer.utils.ValidateUtils.validate(StringUtils.isEmpty((Object)availableListRuleVo.getName()), "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AvailableListRuleEntity entity = (AvailableListRuleEntity)this.availableListRuleMapper.selectById((Serializable)((Object)availableListRuleVo.getId()));
        com.biz.crm.customer.utils.ValidateUtils.validate(entity, "\u60a8\u8981\u7f16\u8f91\u7684\u89c4\u5219\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        Integer dimension = entity.getDimension();
        AvailableListRuleVo oldObject = this.findById(availableListRuleVo.getId());
        this.availableListRuleGoodsService.replace(availableListRuleVo.getGoods(), entity);
        ArrayList oldArea = this.availableListRuleAreaService.findByRuleCode(entity.getRuleCode());
        this.availableListRuleAreaService.replace(availableListRuleVo.getAreaes(), entity);
        BeanUtils.copyProperties((Object)availableListRuleVo, (Object)entity);
        this.availableListRuleMapper.updateById(entity);
        AvailableListRuleVo newObject = this.findById(availableListRuleVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getId(), (Object)oldObject, (Object)newObject);
        oldArea = CollectionUtils.isEmpty(oldArea) ? new ArrayList() : oldArea;
        List oldCodes = null;
        List codes = null;
        if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getCusCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo::getCusCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getTerminalCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo::getTerminalCode).collect(Collectors.toList());
        } else if (entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()) {
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo::getTerminalOrgCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo::getTerminalOrgCode).collect(Collectors.toList());
        }
        HashSet codeSet = new HashSet();
        if (!CollectionUtils.isEmpty(codes)) {
            codeSet.addAll(codes);
        }
        if (!CollectionUtils.isEmpty(oldCodes)) {
            codeSet.addAll(oldCodes);
        }
        this.advise(new ArrayList<String>(codeSet), AvailableListRuleEunm.Dimension.getByCode((Integer)dimension));
    }

    @Override
    @CrmDictMethod
    public AvailableListRuleVo findById(String id) {
        AvailableListRuleVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u89c4\u5219\uff01");
        AvailableListRuleEntity entity = (AvailableListRuleEntity)this.availableListRuleMapper.selectById((Serializable)((Object)id));
        if (null == entity) {
            return vo;
        }
        vo = new AvailableListRuleVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setGoods(this.availableListRuleGoodsService.findByRuleCode(entity.getRuleCode()));
        vo.setAreaes(this.availableListRuleAreaService.findByRuleCode(entity.getRuleCode()));
        return vo;
    }

    @Override
    public AvailableListRuleVo findBySourceId(final String sourceId) {
        AvailableListRuleVo vo = null;
        if (StringUtils.isEmpty((Object)sourceId)) {
            return vo;
        }
        List entities = this.availableListRuleMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("source_id", sourceId);
            }
        });
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return vo;
        }
        AvailableListRuleEntity entity = (AvailableListRuleEntity)entities.get(0);
        if (null == entity) {
            return vo;
        }
        vo = new AvailableListRuleVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setGoods(this.availableListRuleGoodsService.findByRuleCode(entity.getRuleCode()));
        vo.setAreaes(this.availableListRuleAreaService.findByRuleCode(entity.getRuleCode()));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<AvailableListRuleVo> list(AvailableListRuleVo availableListRuleVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)availableListRuleVo.getName()), (Object)"name", (Object)availableListRuleVo.getName())).like(!StringUtils.isEmpty((Object)availableListRuleVo.getCode()), (Object)"code", (Object)availableListRuleVo.getCode())).eq(null != availableListRuleVo.getType(), (Object)"type", (Object)availableListRuleVo.getType())).eq(null != availableListRuleVo.getDimension(), (Object)"dimension", (Object)availableListRuleVo.getDimension())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)availableListRuleVo.getPageNum(), (Integer)availableListRuleVo.getPageSize());
        List<AvailableListRuleVo> list = this.availableListRuleMapper.list(page, (QueryWrapper<AvailableListRuleVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List rules = this.availableListRuleMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return;
        }
        List<String> ruleCodes = rules.stream().map(AvailableListRuleEntity::getRuleCode).collect(Collectors.toList());
        List<AvailableListRuleAreaVo> areaVos = this.availableListRuleAreaService.findByRuleCodes(ruleCodes);
        List<AvailableListRuleVo> ruleVos = this.findByIds(ids);
        this.availableListRuleMapper.deleteBatchIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (AvailableListRuleVo logVo : ruleVos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), logVo.getId(), logVo.getId(), (Object)logVo);
        }
        this.delAdvise(areaVos, rules);
    }

    @Override
    @Transactional
    public void delByParam(AvailableListRuleVo availableListRuleVo) {
        if (null == availableListRuleVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)availableListRuleVo.getName()), (Object)"name", (Object)availableListRuleVo.getName())).eq(null != availableListRuleVo.getCode(), (Object)"code", (Object)availableListRuleVo.getCode())).eq(null != availableListRuleVo.getType(), (Object)"type", (Object)availableListRuleVo.getType());
        List rules = this.availableListRuleMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return;
        }
        List<AvailableListRuleAreaVo> areaVos = this.availableListRuleAreaService.findByRuleCodes(rules.stream().map(AvailableListRuleEntity::getRuleCode).collect(Collectors.toList()));
        this.availableListRuleMapper.delete((Wrapper)wrapper);
        this.delAdvise(areaVos, rules);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List<String> ids = rules.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        List<AvailableListRuleVo> ruleVos = this.findByIds(ids);
        for (AvailableListRuleVo logVo : ruleVos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), logVo.getId(), logVo.getId(), (Object)logVo);
        }
    }

    @Override
    public List<String> findGoodsByCusCodeAndOrgCode(String cusCode, List<String> orgCodes) {
        List<MdmProductRespVo> products;
        ArrayList<String> reList = new ArrayList<String>();
        List<AvailableDo> availableDos = this.availableListRuleGoodsMapper.findGoodsByCusCodeAndOrgCode(cusCode, orgCodes, AvailableListRuleEunm.Dimension.CUS.getCode(), AvailableListRuleEunm.Dimension.CUSORG.getCode());
        if (CollectionUtils.isEmpty(availableDos)) {
            return reList;
        }
        List containLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue() && !StringUtils.isEmpty((Object)vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())).collect(Collectors.toList());
        List nonContainLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue() && !StringUtils.isEmpty((Object)vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())).collect(Collectors.toList());
        List<Object> containLevelsProductCode = new ArrayList();
        List<Object> nonContainLevelsProductCode = new ArrayList();
        if (!CollectionUtils.isEmpty(containLevels) && !CollectionUtils.isEmpty(products = this.mdmProductService.queryBatchByProductLevelCodeList(containLevels.stream().map(AvailableDo::getProductLevelCode).collect(Collectors.toList())))) {
            containLevelsProductCode = products.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(nonContainLevels) && !CollectionUtils.isEmpty(products = this.mdmProductService.queryBatchByProductLevelCodeList(nonContainLevels.stream().map(AvailableDo::getProductLevelCode).collect(Collectors.toList())))) {
            nonContainLevelsProductCode = products.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        }
        availableDos = availableDos.stream().filter(vo -> StringUtils.isEmpty((Object)vo.getProductLevelFlag()) || vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())).collect(Collectors.toList());
        Set availbleList = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()).map(AvailableDo::getGoodsCode).collect(Collectors.toSet());
        availbleList.addAll(containLevelsProductCode);
        Set noAvailbleList = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()).map(AvailableDo::getGoodsCode).collect(Collectors.toSet());
        noAvailbleList.addAll(nonContainLevelsProductCode);
        for (String goodsCode : availbleList) {
            if (noAvailbleList.contains(goodsCode)) continue;
            reList.add(goodsCode);
        }
        return reList;
    }

    @Override
    public List<String> findGoodsByTerminalCodeAndOrgCode(String terminalCode, List<String> orgCodes) {
        List<MdmProductRespVo> products;
        ArrayList<String> reList = new ArrayList<String>();
        List<AvailableDo> availableDos = this.availableListRuleGoodsMapper.findGoodsByTerminalCodeAndOrgCode(terminalCode, orgCodes, AvailableListRuleEunm.Dimension.TERMINAL.getCode(), AvailableListRuleEunm.Dimension.TERMINALORG.getCode());
        if (CollectionUtils.isEmpty(availableDos)) {
            return reList;
        }
        List containLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue() && !StringUtils.isEmpty((Object)vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())).collect(Collectors.toList());
        List nonContainLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue() && !StringUtils.isEmpty((Object)vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())).collect(Collectors.toList());
        List<Object> containLevelsProductCode = new ArrayList();
        List<Object> nonContainLevelsProductCode = new ArrayList();
        if (!CollectionUtils.isEmpty(containLevels) && !CollectionUtils.isEmpty(products = this.mdmProductService.queryBatchByProductLevelCodeList(containLevels.stream().map(AvailableDo::getProductLevelCode).collect(Collectors.toList())))) {
            containLevelsProductCode = products.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(nonContainLevels) && !CollectionUtils.isEmpty(products = this.mdmProductService.queryBatchByProductLevelCodeList(nonContainLevels.stream().map(AvailableDo::getProductLevelCode).collect(Collectors.toList())))) {
            nonContainLevelsProductCode = products.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        }
        availableDos = availableDos.stream().filter(vo -> StringUtils.isEmpty((Object)vo.getProductLevelFlag()) || vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())).collect(Collectors.toList());
        Set availbleList = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()).map(AvailableDo::getGoodsCode).collect(Collectors.toSet());
        availbleList.addAll(containLevelsProductCode);
        Set noAvailbleList = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()).map(AvailableDo::getGoodsCode).collect(Collectors.toSet());
        noAvailbleList.addAll(nonContainLevelsProductCode);
        for (String goodsCode : availbleList) {
            if (noAvailbleList.contains(goodsCode)) continue;
            reList.add(goodsCode);
        }
        return reList;
    }

    @Override
    public List<String> listCusCodesByProductLevel(List<String> productLevels) {
        if (CollectionUtils.isEmpty(productLevels)) {
            return new ArrayList<String>();
        }
        List<String> ruleCodes = this.availableListRuleGoodsMapper.findRuleCodesByProductLevels(productLevels, AvailableListRuleEunm.Dimension.getCusTypeCodes(), YesNoEnum.yesNoEnum.YES.getValue());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return new ArrayList<String>();
        }
        ArrayList<AvailableListRuleAreaVo> areaVos = new ArrayList<AvailableListRuleAreaVo>();
        ArrayList<String> param = new ArrayList<String>(500);
        for (int i = 1; i <= ruleCodes.size(); ++i) {
            param.add(ruleCodes.get(i - 1));
            if (i % 1000 != 0 && i != ruleCodes.size()) continue;
            List<AvailableListRuleAreaVo> vos = this.availableListRuleAreaService.findByRuleCodes(param);
            if (!CollectionUtils.isEmpty(vos)) {
                areaVos.addAll(vos);
            }
            param.clear();
        }
        if (CollectionUtils.isEmpty(areaVos)) {
            return new ArrayList<String>();
        }
        Set cusCodes = areaVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getCusCode())).map(AvailableListRuleAreaVo::getCusCode).collect(Collectors.toSet());
        List<String> cusOrgVos = areaVos.stream().filter(vo -> StringUtils.isEmpty((Object)vo.getCusCode())).map(AvailableListRuleAreaVo::getCusOrgCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cusOrgVos)) {
            return CollectionUtils.isEmpty(cusCodes) ? new ArrayList<String>() : new ArrayList(cusCodes);
        }
        List<String> cusCodesFromOrg = this.mdmCustomerMsgService.findByOrgCodeList(cusOrgVos);
        if (!CollectionUtil.listEmpty(cusCodesFromOrg)) {
            cusCodes.addAll(cusCodesFromOrg);
        }
        return CollectionUtils.isEmpty(cusCodes) ? new ArrayList<String>() : new ArrayList(cusCodes);
    }

    @Override
    public List<String> listTerminalCodesByProductLevel(List<String> productLevels) {
        if (CollectionUtils.isEmpty(productLevels)) {
            return new ArrayList<String>();
        }
        List<String> ruleCodes = this.availableListRuleGoodsMapper.findRuleCodesByProductLevels(productLevels, AvailableListRuleEunm.Dimension.getTerminalTypeCodes(), YesNoEnum.yesNoEnum.YES.getValue());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return new ArrayList<String>();
        }
        ArrayList<AvailableListRuleAreaVo> areaVos = new ArrayList<AvailableListRuleAreaVo>();
        ArrayList<String> param = new ArrayList<String>(500);
        for (int i = 1; i <= ruleCodes.size(); ++i) {
            param.add(ruleCodes.get(i - 1));
            if (i % 1000 != 0 && i != ruleCodes.size()) continue;
            List<AvailableListRuleAreaVo> vos = this.availableListRuleAreaService.findByRuleCodes(param);
            if (!CollectionUtils.isEmpty(vos)) {
                areaVos.addAll(vos);
            }
            param.clear();
        }
        if (CollectionUtils.isEmpty(areaVos)) {
            return new ArrayList<String>();
        }
        Set terminalCodes = areaVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getTerminalCode())).map(AvailableListRuleAreaVo::getTerminalCode).collect(Collectors.toSet());
        List<String> terminalOrgVos = areaVos.stream().filter(vo -> StringUtils.isEmpty((Object)vo.getTerminalCode())).map(AvailableListRuleAreaVo::getTerminalOrgCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(terminalOrgVos)) {
            return CollectionUtils.isEmpty(terminalCodes) ? new ArrayList<String>() : new ArrayList(terminalCodes);
        }
        List<String> terminalCodesFromOrg = this.mdmCustomerMsgService.findByOrgCodeList(terminalOrgVos);
        if (!CollectionUtil.listEmpty(terminalCodesFromOrg)) {
            terminalCodes.addAll(terminalCodesFromOrg);
        }
        return CollectionUtils.isEmpty(terminalCodes) ? new ArrayList<String>() : new ArrayList(terminalCodes);
    }

    @Override
    public Map<String, Boolean> findExistByCodes(List<String> codes) {
        if (CollectionUtil.listEmpty(codes)) {
            return Maps.newHashMap();
        }
        List entities = this.list((Wrapper)Wrappers.query().in((Object)"code", codes));
        if (entities == null) {
            entities = Lists.newArrayList();
        }
        TreeMap result = Maps.newTreeMap();
        entities.forEach(entity -> result.put(entity.getCode(), true));
        codes.forEach(code -> {
            if (result.get(code) == null) {
                result.put(code, false);
            }
        });
        return result;
    }

    private void delAdvise(List<AvailableListRuleAreaVo> areaVos, List<AvailableListRuleEntity> rules) {
        if (CollectionUtils.isEmpty(areaVos)) {
            return;
        }
        Map<String, Integer> ruleMap = rules.stream().collect(Collectors.toMap(AvailableListRuleEntity::getRuleCode, AvailableListRuleEntity::getDimension));
        Map<String, List<AvailableListRuleAreaVo>> areaMap = areaVos.stream().collect(Collectors.groupingBy(AvailableListRuleAreaVo::getRuleCode));
        HashMap typeMap = new HashMap(AvailableListRuleEunm.Dimension.values().length);
        for (Map.Entry<String, List<AvailableListRuleAreaVo>> entry : areaMap.entrySet()) {
            Integer dimension = ruleMap.get(entry.getKey());
            ArrayList codes = (ArrayList)typeMap.get(dimension);
            if (null == codes) {
                codes = new ArrayList();
                typeMap.put(dimension, codes);
            }
            if (dimension.intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()) {
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo::getCusCode).collect(Collectors.toList()));
                continue;
            }
            if (dimension.intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()) {
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo::getCusOrgCode).collect(Collectors.toList()));
                continue;
            }
            if (dimension.intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()) {
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo::getTerminalCode).collect(Collectors.toList()));
                continue;
            }
            if (dimension.intValue() != AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()) continue;
            codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo::getTerminalOrgCode).collect(Collectors.toList()));
        }
        for (Map.Entry<String, List<Object>> entry : typeMap.entrySet()) {
            this.advise(entry.getValue(), AvailableListRuleEunm.Dimension.getByCode((Integer)((Integer)((Object)entry.getKey()))));
        }
    }

    private void advise(List<String> codes, AvailableListRuleEunm.Dimension dimension) {
        if (dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()) {
            this.advise.adviseTarget(this.customerChangeAdviseTargetStrategy, codes);
        } else if (dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()) {
            this.advise.adviseTarget(this.customerOrgChangeAdviseTargetStrategy, codes);
        } else if (dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()) {
            this.advise.adviseTarget(this.terminalChangeAdviseTargetStrategy, codes);
        } else if (dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()) {
            this.advise.adviseTarget(this.terminalOrgChangeAdviseTargetStrategy, codes);
        }
    }

    private List<AvailableListRuleVo> findByIds(List<String> ids) {
        ValidateUtils.validate(ids, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u89c4\u5219\uff01");
        List entities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (null == entities) {
            return Lists.newArrayList();
        }
        List ruleVos = CrmBeanUtil.copyList((List)entities, AvailableListRuleVo.class);
        List<String> ruleCodes = entities.stream().map(entity -> entity.getRuleCode()).collect(Collectors.toList());
        List<AvailableListRuleGoodsVo> goodsVos = this.availableListRuleGoodsService.findByRuleCodes(ruleCodes);
        List<AvailableListRuleAreaVo> areaVos = this.availableListRuleAreaService.findByRuleCodes(ruleCodes);
        ruleVos.forEach(ruleVo -> {
            if (null != goodsVos) {
                ruleVo.setGoods(goodsVos.stream().filter(goodsVo -> ruleVo.getRuleCode().equals(goodsVo.getRuleCode())).collect(Collectors.toList()));
            }
            if (null != areaVos) {
                ruleVo.setAreaes(areaVos.stream().filter(areaVo -> ruleVo.getRuleCode().equals(areaVo.getRuleCode())).collect(Collectors.toList()));
            }
        });
        return ruleVos;
    }
}

