/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlogtemplate.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlogtemplate.entity.LogFieldEntity;
import com.biz.crm.crmlogtemplate.entity.LogTemplateEntity;
import com.biz.crm.crmlogtemplate.mapper.LogTemplateMapper;
import com.biz.crm.crmlogtemplate.service.LogTemplateService;
import com.biz.crm.crmlogtemplate.util.LogTemplateUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.crmlog.template.LogTemplateHandleVO;
import com.biz.crm.nebular.mdm.logtemplate.LogTemplateVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"logTemplateServiceImpl"})
@Service(value="logTemplateService")
public class LogTemplateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<LogTemplateMapper, LogTemplateEntity>
implements LogTemplateService {
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private LogTemplateMapper logTemplateMapper;

    @Override
    public void add(final LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        List entities = this.logTemplateMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("menu_code", vo.getMenuCode());
            }
        });
        if (CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u5df2\u7ecf\u5b58\u5728");
        }
        LogTemplateEntity logTemplateEntity = LogTemplateUtil.voToEntityForAdd(vo);
        this.save((Object)logTemplateEntity);
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(vo.getMenuCode()), (Object)JSON.toJSONString((Object)((Object)logTemplateEntity)));
    }

    @Override
    public PageResult<LogTemplateVo> listWithPage(LogTemplateVo vo) {
        PageResult pageResult = PageResult.builder().data(new ArrayList()).count(Long.valueOf(Long.parseLong("0"))).build();
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(vo.getEnableFlag() != null, (Object)"enable_flag", (Object)vo.getEnableFlag())).like(!StringUtils.isEmpty((String)vo.getBusinessName()), (Object)"business_name", (Object)vo.getBusinessName())).like(!StringUtils.isEmpty((String)vo.getMenuCode()), (Object)"menu_code", (Object)vo.getMenuCode());
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        List<LogTemplateVo> list = this.logTemplateMapper.findList((Page<LogTemplateVo>)page, (QueryWrapper<LogTemplateEntity>)queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return pageResult;
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public LogTemplateVo findById(String id) {
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)((Object)this.getById((Serializable)((Object)id)));
        if (null == logTemplateEntity) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        return LogTemplateUtil.entityToVo(logTemplateEntity);
    }

    @Override
    public void update(LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u6a21\u677f!");
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)((Object)this.getById((Serializable)((Object)vo.getId())));
        if (null == logTemplateEntity) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        logTemplateEntity = LogTemplateUtil.voToEntityForUpdate(vo, logTemplateEntity);
        this.updateById((Object)logTemplateEntity);
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(vo.getMenuCode()), (Object)JSON.toJSONString((Object)((Object)logTemplateEntity)));
    }

    @Override
    public void updateEnable(String id, YesNoEnum.YesNoCodeNumberEnum yesNoCodeNumberEnum) {
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)((Object)this.getById((Serializable)((Object)id)));
        if (null == logTemplateEntity) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        logTemplateEntity.setEnableFlag(yesNoCodeNumberEnum.getCode());
        this.updateById((Object)logTemplateEntity);
        if (yesNoCodeNumberEnum.getCode().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()) {
            this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(logTemplateEntity.getMenuCode()), (Object)"crmLog");
            return;
        }
        this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(logTemplateEntity.getMenuCode()), (Object)JSON.toJSONString((Object)((Object)logTemplateEntity)));
    }

    @Override
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List entities = this.logTemplateMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        this.logTemplateMapper.deleteBatchIds(ids);
        ArrayList<String> codes = new ArrayList<String>();
        for (LogTemplateEntity logTemplateEntity : entities) {
            codes.add(LogTemplateUtil.packageRedisKey(logTemplateEntity.getMenuCode()));
        }
        this.redisTemplate.delete(codes);
    }

    @Override
    public LogTemplateHandleVO findTemplateByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        String str = (String)this.redisTemplate.opsForValue().get((Object)LogTemplateUtil.packageRedisKey(code));
        if (StringUtils.isEmpty((String)str)) {
            LogTemplateEntity logTemplateEntity = this.findTemplateByCodeFromMysql(code);
            if (null != logTemplateEntity && logTemplateEntity.getEnableFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()) {
                this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(code), (Object)JSON.toJSONString((Object)((Object)logTemplateEntity)));
                return (LogTemplateHandleVO)CrmBeanUtil.copyByJson((Object)((Object)logTemplateEntity), LogTemplateHandleVO.class);
            }
            this.redisTemplate.opsForValue().set((Object)LogTemplateUtil.packageRedisKey(code), (Object)"crmLog");
            return null;
        }
        if (str.equals("crmLog")) {
            return null;
        }
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)((Object)JSON.parseObject((String)str, LogTemplateEntity.class));
        HashMap<String, LogFieldEntity> fieldMap = new HashMap<String, LogFieldEntity>();
        logTemplateEntity.setFieldMap(fieldMap);
        LogTemplateEntity entity = LogTemplateUtil.transformEntity(logTemplateEntity, fieldMap);
        return (LogTemplateHandleVO)CrmBeanUtil.copyByJson((Object)((Object)entity), LogTemplateHandleVO.class);
    }

    @Override
    public LogTemplateEntity findTemplateByCodeFromMysql(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        List templateEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(LogTemplateEntity::getMenuCode, (Object)code)).list();
        if (CollectionUtils.isEmpty((Collection)templateEntities)) {
            return null;
        }
        LogTemplateEntity logTemplateEntity = (LogTemplateEntity)((Object)templateEntities.get(0));
        if (null == logTemplateEntity) {
            return null;
        }
        HashMap<String, LogFieldEntity> fieldMap = new HashMap<String, LogFieldEntity>();
        logTemplateEntity.setFieldMap(fieldMap);
        return LogTemplateUtil.transformEntity(logTemplateEntity, fieldMap);
    }

    @Override
    public void copyDataToMysql() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"es_log_template_index"}).withPageable((Pageable)PageRequest.of((int)0, (int)1000)).build();
        List list = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, LogTemplateEntity.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.saveBatch(list);
        }
    }
}

