/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlogtemplate.util;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.crmlogtemplate.entity.LogFieldEntity;
import com.biz.crm.crmlogtemplate.entity.LogTemplateEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.mdm.logtemplate.LogFieldVo;
import com.biz.crm.nebular.mdm.logtemplate.LogTemplateVo;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class LogTemplateUtil {
    public static final String redisPrefix = "crmLog";

    public static String packageRedisKey(String code) {
        return redisPrefix + code;
    }

    public static LogTemplateEntity voToEntityForAdd(LogTemplateVo vo) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        entity.setFieldListStr(JSON.toJSONString(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true)));
        return entity;
    }

    public static LogTemplateEntity voToEntityForUpdate(LogTemplateVo vo, LogTemplateEntity logTemplateEntity) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setFieldListStr(JSON.toJSONString(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true)));
        return entity;
    }

    public static List<LogFieldEntity> voToEntityForField(List<LogFieldVo> filedVods, boolean subFlag) {
        if (CollectionUtils.isEmpty(filedVods)) {
            return new ArrayList<LogFieldEntity>();
        }
        ArrayList<LogFieldEntity> reList = new ArrayList<LogFieldEntity>();
        for (LogFieldVo fieldVo : filedVods) {
            LogFieldEntity fieldEntity = new LogFieldEntity();
            BeanUtils.copyProperties((Object)fieldVo, (Object)fieldEntity);
            if (subFlag) {
                List<LogFieldEntity> subList = LogTemplateUtil.voToEntityForField(fieldVo.getChildrenList(), false);
                fieldEntity.setChildrenListStr(JSON.toJSONString(subList));
            }
            reList.add(fieldEntity);
        }
        return reList;
    }

    public static LogTemplateEntity transformEntity(LogTemplateEntity logTemplateEntity, Map<String, LogFieldEntity> fieldMap) {
        if (StringUtils.isEmpty((String)logTemplateEntity.getFieldListStr())) {
            return logTemplateEntity;
        }
        List fieldList = JSONArray.parseArray((String)logTemplateEntity.getFieldListStr(), LogFieldEntity.class);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return logTemplateEntity;
        }
        for (LogFieldEntity logFieldEntity : fieldList) {
            fieldMap.put(logFieldEntity.getFieldName(), logFieldEntity);
            HashMap<String, LogFieldEntity> childrenMap = new HashMap<String, LogFieldEntity>();
            logFieldEntity.setChildren(childrenMap);
            if (StringUtils.isEmpty((String)logFieldEntity.getChildrenListStr())) continue;
            List childrenList = JSONArray.parseArray((String)logFieldEntity.getChildrenListStr(), LogFieldEntity.class);
            if (CollectionUtils.isEmpty((Collection)fieldList)) continue;
            for (LogFieldEntity chiledFiled : childrenList) {
                childrenMap.put(chiledFiled.getFieldName(), chiledFiled);
            }
        }
        return logTemplateEntity;
    }

    public static LogTemplateVo entityToVo(LogTemplateEntity logTemplateEntity) {
        LogTemplateVo vo = new LogTemplateVo();
        BeanUtils.copyProperties((Object)((Object)logTemplateEntity), (Object)vo);
        vo.setFieldList(LogTemplateUtil.entityToVoForFiled(logTemplateEntity.getFieldListStr()));
        return vo;
    }

    public static List<LogFieldVo> entityToVoForFiled(String fieldListStr) {
        ArrayList<LogFieldVo> reList = new ArrayList<LogFieldVo>();
        if (StringUtils.isEmpty((String)fieldListStr)) {
            return reList;
        }
        List fileds = JSONArray.parseArray((String)fieldListStr, LogFieldEntity.class);
        if (CollectionUtils.isEmpty((Collection)fileds)) {
            return reList;
        }
        for (LogFieldEntity logFieldEntity : fileds) {
            LogFieldVo logFieldVo = new LogFieldVo();
            BeanUtils.copyProperties((Object)logFieldEntity, (Object)logFieldVo);
            logFieldVo.setChildrenList(new ArrayList());
            reList.add(logFieldVo);
            if (logFieldVo.getHostType().intValue() == LogEunm.HostTypeEunm.BASIC.getCode().intValue() || StringUtils.isEmpty((String)logFieldEntity.getChildrenListStr())) continue;
            logFieldVo.setChildrenList(JSONArray.parseArray((String)logFieldEntity.getChildrenListStr(), LogFieldVo.class));
        }
        return reList;
    }
}

