/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.config.CrmDataSource;
import com.biz.crm.config.DataSourceType;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.KmsOrderTypeEnum;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.config.MapperConfig;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.model.DmsAcceptanceVoucherEntity;
import com.biz.crm.kms.model.DmsIndentVoucherEntity;
import com.biz.crm.kms.model.DmsPriceVoucherEntity;
import com.biz.crm.kms.model.DmsReturnVoucherEntity;
import com.biz.crm.kms.service.DmsAcceptanceVoucherService;
import com.biz.crm.kms.service.DmsIndentVoucherService;
import com.biz.crm.kms.service.DmsPriceVoucherService;
import com.biz.crm.kms.service.DmsReturnVoucherService;
import com.biz.crm.kms.service.DmsVoucherDetailService;
import com.biz.crm.kms.service.KmsOrderService;
import com.biz.crm.nebular.mdm.kms.api.KmsAcceptanceVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRulePageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsIndentVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsOrderDetailVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPriceVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultBodyVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsReturnVoucherVo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"KmsOrderServiceExpandImpl"})
@CrmDataSource(value=DataSourceType.SLAVE)
public class KmsOrderServiceImpl
implements KmsOrderService {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;
    @Autowired
    private DmsAcceptanceVoucherService dmsAcceptanceVoucherService;
    @Autowired
    private DmsIndentVoucherService dmsIndentVoucherService;
    @Autowired
    private DmsReturnVoucherService dmsReturnVoucherService;
    @Autowired
    private DmsPriceVoucherService dmsPriceVoucherService;
    @Autowired
    private DmsVoucherDetailService dmsVoucherDetailService;

    @Override
    public void fetchAcceptanceOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>> reference;
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(this.kmsProperties.getAcceptanceInvoiceId());
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>>(){}));
        List kmsAcceptanceVoucherVos = Optional.of(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsAcceptanceVoucherVos)) {
            return;
        }
        List<DmsAcceptanceVoucherEntity> list = KmsConverter.INSTANCE.acceptance2entity(kmsAcceptanceVoucherVos);
        Collection<DmsAcceptanceVoucherEntity> values = list.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(x -> x.getAcceptanceDate() != null ? x.getAcceptanceDate() : YesNoEnum.yesNoEnum.ZERO.getValue())))).values();
        list = new ArrayList<DmsAcceptanceVoucherEntity>(values);
        List<String> collect = list.stream().map(DmsAcceptanceVoucherEntity::getOrderNumber).collect(Collectors.toList());
        System.out.println(1);
        this.saveDetail(collect, this.kmsProperties.getAcceptanceInvoiceId(), KmsOrderTypeEnum.ACCEPTANCE.getCode());
        this.dmsAcceptanceVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchIndentOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>> reference;
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(this.kmsProperties.getIndentInvoiceId());
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>>(){}));
        List kmsIndentVoucherVos = Optional.of(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsIndentVoucherVos)) {
            return;
        }
        List<DmsIndentVoucherEntity> list = KmsConverter.INSTANCE.indent2entity(kmsIndentVoucherVos);
        Collection<DmsIndentVoucherEntity> values = list.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(x -> x.getOrderDate() != null ? x.getOrderDate() : YesNoEnum.yesNoEnum.ZERO.getValue())))).values();
        list = new ArrayList<DmsIndentVoucherEntity>(values);
        List<String> collect = list.stream().map(DmsIndentVoucherEntity::getOrderNumber).collect(Collectors.toList());
        this.saveDetail(collect, this.kmsProperties.getIndentInvoiceId(), KmsOrderTypeEnum.INDENT.getCode());
        this.dmsIndentVoucherService.saveOrUpdateBatch(list);
    }

    private void saveDetail(List<String> orderNumberList, String bsInvoiceId, int orderType) {
        if (CollectionUtils.isEmpty(orderNumberList)) {
            return;
        }
        Collection values = orderNumberList.parallelStream().filter(x -> !StringUtils.isEmpty((Object)x)).flatMap(x -> this.obtainDetails((String)x, bsInvoiceId).stream()).peek(x -> x.setKmsOrderType(Integer.valueOf(orderType))).map(KmsConverter.INSTANCE::order2Entity).collect(Collectors.toMap(BaseIdEntity::getId, Function.identity(), (x1, x2) -> x2)).values();
        ArrayList collect = new ArrayList(values);
        if (!CollectionUtils.isEmpty(collect)) {
            this.dmsVoucherDetailService.saveOrUpdateBatch(collect);
        }
    }

    @Override
    public void fetchPriceOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>> reference;
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(this.kmsProperties.getPriceInvoicedId());
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>>(){}));
        List kmsPriceVoucherVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsPriceVoucherVos)) {
            return;
        }
        List<DmsPriceVoucherEntity> list = KmsConverter.INSTANCE.price2entity(kmsPriceVoucherVos);
        this.dmsPriceVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchReturnOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>> reference;
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(this.kmsProperties.getReturnInvoiceId());
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>>(){}));
        List kmsReturnVoucherVos = Optional.of(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsReturnVoucherVos)) {
            return;
        }
        List<DmsReturnVoucherEntity> list = KmsConverter.INSTANCE.return2entity(kmsReturnVoucherVos);
        Collection<DmsReturnVoucherEntity> values = list.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(x -> x.getOrderDate() != null ? x.getOrderDate() : YesNoEnum.yesNoEnum.ZERO.getValue())))).values();
        list = new ArrayList<DmsReturnVoucherEntity>(values);
        List<String> collect = list.stream().map(DmsReturnVoucherEntity::getOrderNumber).collect(Collectors.toList());
        this.saveDetail(collect, this.kmsProperties.getReturnInvoiceId(), KmsOrderTypeEnum.RETURN.getCode());
        this.dmsReturnVoucherService.saveOrUpdateBatch(list);
    }

    protected KmsGrabRulePageVo setUpOrderReq(String bsInvoiceId) {
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setBsInvoiceId(bsInvoiceId);
        kmsGrabRuleVo.setFieldCategory("INVOICE");
        KmsPageVo kmsPageVo = new KmsPageVo(Integer.valueOf(0), Integer.valueOf(-1));
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setPage(kmsPageVo);
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
        return kmsGrabRulePageVo;
    }

    @Override
    public List<KmsOrderDetailVo> obtainDetails(String orderNumber, String bsInvoiceId) {
        if (StringUtils.isEmpty((Object)orderNumber) || StringUtils.isEmpty((Object)bsInvoiceId)) {
            return null;
        }
        ObjectNode instance = MapperConfig.instance(this.kmsProperties, 1, -1);
        ObjectNode req = MapperConfig.instance();
        req.put("bsInvoiceId", bsInvoiceId);
        req.put("fieldCategory", "GOODS");
        req.put("isEdit", 0);
        req.put("isSplit", 0);
        req.put("orderNumber", orderNumber);
        req.put("versionNumber", 1);
        req.put("tenantryId", this.kmsProperties.getTenantryId());
        instance.set("reqVo", (JsonNode)req);
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsOrderDetailVo>>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsOrderDetailVo>>>>(){};
        String url = this.kmsProperties.getUrl() + "/orderController/getOrderDetail";
        return Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)instance, (ParameterizedTypeReference)reference)).map(x -> {
            log.info("[kms\u8ba2\u5355\u8be6\u60c5][remove]entity:{}", x);
            return x;
        }).map(HttpEntity::getBody).filter(x -> "SUCCESS".equals(x.getCode())).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(Collections.emptyList());
    }
}

