/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmSystemLoginServiceExpandImpl"})
public class MdmSystemLoginServiceImpl
implements MdmSystemLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSystemLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            LoginHelpUtil.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            LoginHelpUtil.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            LoginHelpUtil.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        LoginHelpUtil.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        String userName = LoginHelpUtil.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        LoginHelpUtil.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        String userName = LoginHelpUtil.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    }

    @Override
    public void checkEmailExistAndUsable(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock(user.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode(reqVo.getFromType(), verification, user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = LoginHelpUtil.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = LoginHelpUtil.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        LoginHelpUtil.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, false);
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        LoginHelpUtil.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType(user.getUserType(), reqVo.getFromType());
        LoginHelpUtil.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        LoginHelpUtil.sendVerificationCode(reqVo.getFromType(), verification, user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        MdmLoginTypeControlVo controlVo = new MdmLoginTypeControlVo();
        try {
            Map<String, String> map = this.mdmDictDataService.getDictDataMap("login_control_config");
            controlVo.setLoginByUserName(YesNoEnum.yesNoEnum.ZERO.getValue().equals(map.get("system_login_by_user_name_pwd")) ? YesNoEnum.yesNoEnum.ZERO.getValue() : YesNoEnum.yesNoEnum.ONE.getValue());
            controlVo.setLoginByPhone(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_phone_pwd")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByPhoneVerification(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_phone_verification")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByEmail(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_email_pwd")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByEmailVerification(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_email_verification")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByWeChatWork(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_we_chat_work")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setResetByPhone(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_reset_by_phone")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setResetByEmail(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_reset_by_email")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u63a7\u5236\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return controlVo;
    }

    protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, String fromType, boolean getLastLoginLog, boolean resetPassword) {
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
            MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
            userRedis.setPoscode(positionUserOrg.getPositionCode());
            userRedis.setPosname(positionUserOrg.getPositionName());
            userRedis.setOrgcode(positionUserOrg.getOrgCode());
            userRedis.setOrgname(positionUserOrg.getOrgName());
            mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
            mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
            mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
            mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        } else if (UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUserType())) {
            MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
            if (customer == null) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            userRedis.setCustcode(customer.getCustomerCode());
            userRedis.setCustname(customer.getCustomerName());
            mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
            mdmLoginRespVo.setCustomerName(customer.getCustomerName());
            mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        }
        userRedis.setFromtype(fromType);
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), fromType, DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

