/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.config.MapperConfig;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmProService;
import com.biz.crm.nebular.mdm.kms.api.KmsProInsertVo;
import com.biz.crm.nebular.mdm.kms.api.KmsProVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsUnitVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmProServiceExpandImpl"})
public class MdmProServiceImpl
implements MdmProService {
    private static final Logger log = LoggerFactory.getLogger(MdmProServiceImpl.class);
    @Value(value="${jobId:3726962913e5877a3ed3a2eae59728c2}")
    private String jobId;
    @Value(value="${proBrand:f00b26660f74a2810dea8652534cfdad}")
    private String proBrand;
    @Autowired
    private KmsProperties kmsProperties;
    @Autowired
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmProductService mdmProductService;

    @Override
    public void add(KmsProVo kmsProVo) {
        KmsProInsertVo kmsProInsertVo = new KmsProInsertVo();
        kmsProInsertVo.setMap(kmsProVo);
        kmsProInsertVo.setId(kmsProVo.getId());
        kmsProInsertVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProInsertVo.setUserId(this.kmsProperties.getUserId());
        kmsProInsertVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/addProDetails?access_token=" + this.kmsProperties.getAccessToken();
        ParameterizedTypeReference<KmsResultVo<Object>> reference = new ParameterizedTypeReference<KmsResultVo<Object>>(){};
        Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsProInsertVo, (ParameterizedTypeReference)reference)).map(HttpEntity::getBody).map(x -> {
            log.info("[kms\u5546\u54c1][\u65b0\u589e]entity:{}", x);
            return x;
        }).filter(x -> "ERROR".equals(x.getCode())).ifPresent(x -> {
            throw new BusinessException("KMS\u540c\u6b65\u5931\u8d25");
        });
    }

    @Override
    public void add(MdmProductReqVo mdmProductReqVo) {
        if (!MapperConfig.validProduct(this.kmsProperties)) {
            return;
        }
        KmsProVo kmsProVo = KmsConverter.INSTANCE.product2Kms(mdmProductReqVo);
        kmsProVo.setJob(this.jobId);
        kmsProVo.setProBrand(this.proBrand);
        kmsProVo.setUnit(this.convertUnit(mdmProductReqVo));
        this.add(kmsProVo);
    }

    protected List<KmsUnitVo> convertUnit(MdmProductReqVo mdmProductReqVo) {
        String saleUnit = mdmProductReqVo.getSaleUnit();
        if (StringUtils.isEmpty((Object)saleUnit)) {
            return Collections.emptyList();
        }
        MdmDictDataEntity one = (MdmDictDataEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)"product_sale_unit")).eq(MdmDictDataEntity::getDictCode, (Object)saleUnit)).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (one == null) {
            return Collections.emptyList();
        }
        KmsUnitVo kmsUnitVo = new KmsUnitVo();
        kmsUnitVo.setSupplementaryUnitId(one.getId());
        return Collections.singletonList(kmsUnitVo);
    }

    @Override
    public void update(KmsProVo kmsProVo) {
    }

    @Override
    public void update(MdmProductReqVo mdmProductReqVo) {
        if (!MapperConfig.validProduct(this.kmsProperties)) {
            return;
        }
        String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/updateProDetails?access_token=" + this.kmsProperties.getAccessToken();
        KmsProVo kmsProVo = KmsConverter.INSTANCE.product2Kms(mdmProductReqVo);
        kmsProVo.setJob(this.jobId);
        kmsProVo.setProBrand(this.proBrand);
        kmsProVo.setUnit(this.convertUnit(mdmProductReqVo));
        KmsProInsertVo kmsProInsertVo = new KmsProInsertVo();
        kmsProInsertVo.setMap(kmsProVo);
        kmsProInsertVo.setId(kmsProVo.getId());
        kmsProInsertVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProInsertVo.setUserId(this.kmsProperties.getUserId());
        kmsProInsertVo.setUsername(this.kmsProperties.getUsername());
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsProInsertVo, String.class);
        log.info("[kms\u5546\u54c1][update]entity:{}", (Object)entity);
    }

    @Override
    public void remove(List<String> productCodeList) {
        if (!MapperConfig.validProduct(this.kmsProperties)) {
            return;
        }
        if (CollectionUtils.isEmpty(productCodeList)) {
            return;
        }
        for (String id : productCodeList) {
            if (StringUtils.isEmpty((Object)id)) continue;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("tenantryId", this.kmsProperties.getTenantryId());
            paramMap.put("userId", this.kmsProperties.getUserId());
            paramMap.put("username", this.kmsProperties.getUsername());
            paramMap.put("id", id);
            String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/deleteById?access_token=" + this.kmsProperties.getAccessToken();
            ResponseEntity enitty = RestTemplateUtils.postForEntity((String)url, null, paramMap, String.class);
            log.info("[kms\u5546\u54c1][\u5220\u9664]entity:{}", (Object)enitty);
        }
    }

    @Override
    public void sync() {
        try {
            this.mdmProductService.lambdaQuery().list().parallelStream().map(x -> (MdmProductReqVo)CrmBeanUtil.copy((Object)x, MdmProductReqVo.class)).forEach(this::add);
        }
        catch (Exception e) {
            log.error("kms\u5546\u54c1\u540c\u6b65\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public void add(List<MdmProductReqVo> list) {
        if (!MapperConfig.validProduct(this.kmsProperties)) {
            return;
        }
        if (!CollectionUtils.isEmpty(list)) {
            try {
                list.parallelStream().forEach(this::add);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u65b0\u589e\u5546\u54c1\u5931\u8d25:{}", (Throwable)e);
            }
        }
    }
}

