/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.AdminEnum;
import com.biz.crm.eunm.mdm.MdmTableConfigFunctionTypeEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigBatchVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubButtonReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigRespVo;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.tableconfig.mapper.MdmTableConfigMapper;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.model.MdmTableConfigEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.tableconfig.service.IMdmTableConfigService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ColumnConfigPersonalUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.cache.TableConfigUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTableConfigServiceExpandImpl"})
public class MdmTableConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTableConfigMapper, MdmTableConfigEntity>
implements IMdmTableConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmTableConfigServiceImpl.class);
    @Resource
    private MdmTableConfigMapper mdmTableConfigMapper;
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Autowired
    private MdmPositionRoleService mdmPositionRoleService;
    @Autowired
    private MdmButtonRoleService mdmButtonRoleService;

    @Override
    public PageResult<MdmTableConfigRespVo> findList(MdmTableConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmTableConfigRespVo> list = this.mdmTableConfigMapper.findList((Page<MdmTableConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTableConfigRespVo query(MdmTableConfigReqVo reqVo) {
        List personalList;
        UserRedis user;
        MdmTableConfigRespVo resultRespVo = null;
        String parentCode = reqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubEntity mdmFunctionSubEntity = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionType, (Object)MdmTableConfigFunctionTypeEnum.LIST_CONFIG.getCode())).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).one();
        Assert.notNull((Object)mdmFunctionSubEntity, (String)"\u5217\u8868\u914d\u7f6e\u4e0d\u5b58\u5728");
        resultRespVo = this.setListConfig(parentCode, functionCode, mdmFunctionSubEntity);
        TableConfigUtil.setTableConfig((String)parentCode, (String)functionCode, (Object)resultRespVo);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)resultRespVo.getColumn()) && (user = UserUtils.getUser()) != null && !StringUtils.isEmpty((Object)user.getPoscode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(personalList = ColumnConfigPersonalUtil.getColumnConfigPersonal((String)parentCode, (String)functionCode, (String)user.getPoscode())))) {
            Map<String, MdmColumnConfigPersonalRespVo> map = personalList.stream().collect(Collectors.toMap(MdmColumnConfigPersonalRespVo::getField, v -> v));
            resultRespVo.getColumn().forEach(item -> {
                if (!StringUtils.isEmpty((Object)item.getTitle())) {
                    if (!map.containsKey(item.getField())) {
                        item.setFormorder("100");
                    } else {
                        MdmColumnConfigPersonalRespVo personalVo = (MdmColumnConfigPersonalRespVo)map.get(item.getField());
                        item.setFormorder(personalVo.getFormOrder());
                        item.setVisible(Boolean.valueOf(YesNoEnum.yesNoEnum.ONE.getValue().equals(personalVo.getVisible())));
                    }
                }
            });
            resultRespVo.getColumn().sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(100)));
        }
        return resultRespVo;
    }

    protected MdmTableConfigRespVo setListConfig(String parentCode, String functionCode, MdmFunctionSubEntity mdmFunctionSubEntity) {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        String username = user.getUsername();
        MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo = new MdmFunctionSubButtonReqVo();
        mdmFunctionSubButtonReqVo.setParentCode(parentCode);
        mdmFunctionSubButtonReqVo.setFunctionCode(functionCode);
        mdmFunctionSubButtonReqVo.setShowMode("true");
        List<Object> mdmButtonConfigRespVos = this.mdmFunctionSubButtonService.buttonList(mdmFunctionSubButtonReqVo);
        log.info("[\u5217\u8868\u914d\u7f6e][\u6309\u94ae\u5217\u8868]:{}", mdmButtonConfigRespVos);
        if (!CollectionUtils.isEmpty(mdmButtonConfigRespVos)) {
            String positionCode = user.getPoscode();
            Assert.hasText((String)positionCode, (String)"\u5f53\u524d\u804c\u4f4d\u672a\u6307\u5b9a");
            List<String> roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
            Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u804c\u4f4d[" + positionCode + "]\u672a\u5206\u914d\u89d2\u8272"));
            if (!AdminEnum.ADMIN.name().equalsIgnoreCase(username) && roleCodeList.stream().noneMatch(x -> AdminEnum.ADMIN.name().equalsIgnoreCase((String)x))) {
                List<String> buttonCodeList = this.mdmButtonRoleService.findButtonCodeByRole(roleCodeList, parentCode, functionCode);
                mdmButtonConfigRespVos = !CollectionUtils.isEmpty(buttonCodeList) ? mdmButtonConfigRespVos.stream().filter(x -> buttonCodeList.contains(x.getButtonCode())).collect(Collectors.toList()) : Collections.emptyList();
            }
        }
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        mdmColumnConfigReqVo.setParentCode(parentCode);
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = this.mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        log.info("[\u5217\u8868\u914d\u7f6e][\u5b57\u6bb5\u5217\u8868]:{}", mdmColumnConfigRespVos);
        MdmTableConfigRespVo mdmTableConfigRespVo = new MdmTableConfigRespVo();
        mdmTableConfigRespVo.setColumn(mdmColumnConfigRespVos);
        mdmTableConfigRespVo.setButtonVos(mdmButtonConfigRespVos);
        mdmTableConfigRespVo.setUrl(mdmFunctionSubEntity.getApiUrl());
        return mdmTableConfigRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTableConfigReqVo reqVo) {
        MdmTableConfigEntity entity = (MdmTableConfigEntity)CrmBeanUtil.copy((Object)reqVo, MdmTableConfigEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTableConfigReqVo reqVo) {
        MdmTableConfigEntity entity = (MdmTableConfigEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    public List<MdmColumnConfigRespVo> formQuery(MdmTableConfigReqVo mdmTableConfigReqVo) {
        String parentCode = mdmTableConfigReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = mdmTableConfigReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = this.setupQueryConfig(parentCode, functionCode);
        return mdmColumnConfigRespVos;
    }

    protected List<MdmColumnConfigRespVo> setupQueryConfig(String parentCode, String functionCode) {
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        mdmColumnConfigReqVo.setParentCode(parentCode);
        List<Object> mdmColumnConfigRespVos = this.mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        if (CollectionUtils.isEmpty(mdmColumnConfigRespVos)) {
            mdmColumnConfigRespVos = mdmColumnConfigRespVos.stream().peek(x -> {
                if (StringUtils.isEmpty((Object)x.getFormvalue())) {
                    x.setFormvalue("");
                }
                if (StringUtils.isEmpty((Object)x.getType())) {
                    x.setType("input");
                }
            }).collect(Collectors.toList());
        }
        return mdmColumnConfigRespVos;
    }

    @Override
    public MdmTableConfigRespVo queryFunction(MdmTableConfigReqVo mdmTableConfigReqVo) {
        String functionCode = mdmTableConfigReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubEntity mdmFunctionSubEntity = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getFunctionType, (Object)MdmTableConfigFunctionTypeEnum.LIST_CONFIG.getCode())).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).one();
        Assert.notNull((Object)mdmFunctionSubEntity, (String)"\u5217\u8868\u914d\u7f6e\u4e0d\u5b58\u5728");
        String parentCode = mdmFunctionSubEntity.getParentCode();
        Assert.hasText((String)parentCode, (String)("\u529f\u80fd\u5217\u8868:" + functionCode + "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        return this.setListConfig(parentCode, functionCode, mdmFunctionSubEntity);
    }

    @Override
    public List<MdmColumnConfigBatchVo> formBatchQuery(List<MdmColumnConfigBatchVo> mdmColumnConfigBatchVos) {
        if (CollectionUtils.isEmpty(mdmColumnConfigBatchVos)) {
            return Collections.emptyList();
        }
        return mdmColumnConfigBatchVos.stream().peek(x -> {
            MdmTableConfigReqVo mdmTableConfigReqVo = new MdmTableConfigReqVo();
            mdmTableConfigReqVo.setParentCode(x.getParentCode());
            mdmTableConfigReqVo.setFunctionCode(x.getFunctionCode());
            x.setMdmColumnConfigRespVos(this.formQuery(mdmTableConfigReqVo));
        }).collect(Collectors.toList());
    }
}

